--
-- � Copyright 2011 Autodesk, Inc. All rights reserved.
--

fn CVGetMod cvObj modClass =
(
 return cvObj.modifiers[modClass]
)

global DYNuiResourcesStartupScript = #( \
  ~STARTUP_ERROR_START_PROBLEM~, \         -- 01
  ~STARTUP_TITLE_INFORMATION~, \           -- 02
  ~STARTUP_WARNING_INIT_3DSMAX~, \         -- 03
  ~STARTUP_WARNING_INI_FILE~, \            -- 04
  ~STARTUP_INSTALL_FOLDER~, \              -- 05
  ~STARTUP_WARNING_RESTART~, \             -- 06
  ~STARTUP_WARNING_INITIAL_SETTINGS~, \    -- 07
  ~STARTUP_QUERY_INITIAL_SETTINGS~, \      -- 08
  ~STARTUP_LABEL_YES~, \                   -- 09
  ~STARTUP_LABEL_NO~, \                    -- 10
  ~STARTUP_LABEL_DISPLAY_WARNING~, \       -- 11
  ~STARTUP_TITLE_INITIALIZE~, \            -- 12
  ~STARTUP_GRPS_SYSTEM_UNITS~, \           -- 13
  ~STARTUP_GRPS_RESOURCE_KIT~, \           -- 14
  ~STARTUP_GRPS_START_MODE~, \             -- 15
  ~STARTUP_BUTTON_OK~, \                   -- 16
  ~STARTUP_BUTTON_CANCEL~, \               -- 17
  ~STARTUP_ERROR_MULTIPLE_KITS~, \         -- 18
  ~STARTUP_WARNING_AUTOMATIC_START~, \     -- 19
  ~STARTUP_LABEL_MANUAL~, \                -- 20
  ~STARTUP_LABEL_AUTOMATIC~, \             -- 21
  ~STARTUP_LABEL_CURRENT_UNITS~, \         -- 22
  ~STARTUP_LABEL_METERS_OR_FEET~, \        -- 23
  ~STARTUP_LABEL_MATCH_CIVIL_PROJECT~, \   -- 24
  ~STARTUP_LABEL_SYSTEM_UNITS~, \          -- 25
  ~STARTUP_UNIT_INCHES~, \                 -- 26
  ~STARTUP_UNIT_FEET~, \                   -- 27
  ~STARTUP_UNIT_MILES~, \                  -- 28
  ~STARTUP_UNIT_MILLIMETERS~, \            -- 29
  ~STARTUP_UNIT_CENTIMETERS~, \            -- 30
  ~STARTUP_UNIT_METERS~, \                 -- 31
  ~STARTUP_UNIT_KILOMETERS~, \             -- 32
  ~STARTUP_QUERY_SYSTEM_UNITS~, \          -- 33
  ~STARTUP_QUERY_RESOURCE_KIT~, \          -- 34
  ~STARTUP_ERROR_INI_FILE~, \              -- 35
  ~STARTUP_ERROR_PLUGINS~, \               -- 36
  ~STARTUP_ERROR_CODE~, \                  -- 37
  ~STARTUP_ERROR_RESOURCE_FOLDERS~, \      -- 38
  ~STARTUP_ERROR_RESOURCE_INSTALLED~, \    -- 39
  ~STARTUP_ERROR_RESOURCE_LOCATION~, \     -- 40
  ~STARTUP_MENU_START~, \                  -- 41
  ~STARTUP_FILETYPE_SCRIPT~, \             -- 42
  ~STARTUP_TITLE_INITIALIZE_FAILED~ \      -- 43
)

function CVGetInstallDir =
(
	-- Civil View install directory stored in HKEY_LOCAL_MACHINE\SOFTWARE\Autodesk\3dsMax\22.0\CivilViewInstalldir (replace 22 with current release)
	local keyName = "SOFTWARE\\Autodesk\\3dsMax\\"
	keyName += ((maxVersion())[4] as string) -- Major version. ex: 22
	keyName += ".0" -- Full release and point releases store registry keys in <major>.0

	local CVKey = undefined
	local openRes = registry.openkey HKEY_LOCAL_MACHINE keyName accessRights:#readOnly key:&CVKey

	local installPath = ""
	if (openRes and CVKey != undefined) then
	(
		local keyValue = undefined
		local queryRes = registry.queryValue CVkey "CivilViewInstalldir" value:&keyValue
		if (queryRes and keyValue != undefined) then
		(
			installPath = keyValue as string
		)
	)
	registry.closeKey CVKey
	return installPath
)

if DYNcivilViewVersion == undefined then
(
  /*
     A quick check as to whether CivilView.Plugin.ms is likely to have been loaded when 3ds Max
     Started.  If not, none of the global functions used in this startup script will be
     available, so bail out.
  */
  messagebox (DYNuiResourcesStartupScript[1]) title:DYNuiResourcesStartupScript[43]
)
else
(
  --- Define *** NON-LOCALIZABLE *** strings as GLOBAL variables
  global DYNdotNetSystemClass         = dotNetClass "System.Environment"                 -- Used to get system folder locations in DVSP
  global DYNdotNetFolderClass         = dotNetClass "System.Environment+SpecialFolder"   -- Used to get system folder locations in DVSP

  global DYNlocalRmsPath              = DYNstringRMSfolderName + "\\*.rms"  -- local resource kit folder for specified file type
  global DYNlocalFisPath              = DYNstringFISfolderName + "\\*.fis"  -- local resource kit folder for specified file type
  global DYNlocalRosPath              = DYNstringROSfolderName + "\\*.ros"  -- local resource kit folder for specified file type
  global DYNlocalOpsPath              = DYNstringOPSfolderName + "\\*.ops"  -- local resource kit folder for specified file type
  global DYNlocalSosPath              = DYNstringSOSfolderName + "\\*.sos"  -- local resource kit folder for specified file type
  global DYNlocalBosPath              = DYNstringBOSfolderName + "\\*.bos"  -- local resource kit folder for specified file type

  global DYNcountryPrefix             = "Country/"
  global DYNprojectPrefix             = "Project/"
  global DYNprivatePrefix             = "Private/"

  global DYNcountryRootPath           = CVGetInstallDir()
  global DYNcountryExists             = 0 -- will equal 0 if the selected country kit does not exist in the specified Country Root Path

  global DYNmarkerName                = "DYNTemporaryMarker"                -- Prefix for all Dynamite Temporary Marker Objects
  global DYNmatModName                = "VspMatMod"                         -- Name for Material Modifiers placed on objects (important that this value is ALWAYS the same!)
  global DYNnoName                    = "[Empty]"
  global DYNimportedAcadPrefix        = "Layer:"

  global DYNprimitiveTypes            = #("Box", "Cylinder", "Pyramid", "Sphere", "Teapot", "Geosphere", "Plane")
  global DYNfileSelectorFileType      = "SOS"

  --- Set Up Remaining GLobal Variables ---------------------------------------------
  global DYNmainINI                          -- MUST Initially be {undefined} but after running DYNFUNcheckINIfile() will show if INI file was found.
  global DYNpluginStatus              = 0    -- Used for checking if required plugins are loaded in conjunction with DYNFUNcheckPlugins()
  global DYNdateLocale                = 1    -- Sets the locale for date printing functions (d/m/y or m/d/y for instance)
  global DYNexplorerLoaded            = false-- a flag which identifies whether DVSP Explorer panel has already been displayed in this max session. This prevents on-demand CSP rollout defnitions from being loaded except on first load.
  global DYNcveImportMode             = 1    -- Defines which file format the CVE Import Panel is working with (1: GENIO; 2: MX Model File; 3: 12D Ascii; 4: LandXML)
  global DYNcveReadErrorArray         = #()  -- Provides a list of strings which could not be read from the source file in a CVE import session and an associated reason.  Can be displayed in a listView if desired.
  global DYNcveBuildErrorArray        = #()  -- Provides a list of strings which could not be built in a CVE import session and an associated reason.  Can be displayed in a listView if desired.

  global DYNdotNetExt                        -- Used to store reference to DVSP extensions dotNetObject
  global DYNdotNetFileBase                   -- Used to store reference to DVSP extensions file dotNetObject
  global DYNdotNetDVSPctrls                  -- Used to store reference to DVSP bitmaps
  global DYNdotNetDSIM
  global dnImportClass
  global dnImportObject

  global DYNdnGenioConverter
  global DYNdnMxConverter
  global DYNdn12dConverter
  global DYNdnXmlConverter

  global DYNdnLgImageList
  global DYNdnTvImageIcon
  global DYNdnTabAlignClass
  global DYNdnHorAlignClass
  global DYNdnmouseClass
  global DYNdndockClass
  global DYNdnSortOrderClass
  global DYNdnViewClass
  global DYNdnBorderStyleClass
  global DYNdnStndFont
  global DYNdnBoldFont

  global DYNsimVehicles               = #()
  global DYNsimVehicleTypes           = #()
  global DYNsimVehicleTypeCounts      = #()
  global DYNsimInfoSceneTime          = #()
  global DYNsimGlobals                = #()

  global DYN12dWireExp                = #()
  global DYN12dAttExp                 = #()
  global DYN12dMatExp                 = #()
  global DYNxmlWireExp                = #()
  global DYNxmlAttExp                 = #()
  global DYNxmlMatExp                 = #()
  global DYNmxModelWireExp            = #()
  global DYNmxModelAttExp             = #()
  global DYNmxModelMatExp             = #()
  global DYNcivil3dWireExp            = #()

  --- remember to update DYNFUNflagPreviouslyImportedObjects if this list is expanded --
  global DYNc3dAlignments             = #()
  global DYNc3dCorridorBaselines      = #()
  global DYNc3dCorridorRegions        = #()
  global DYNc3dCorridorFeatureLines   = #()
  global DYNc3dNamedLandFeatureLines  = #()
  global DYNc3dUnnamedLandFeatureLines= #()
  global DYNc3dSurfaces               = #()
  global DYNc3dCorridorSurfaces       = #()
  global DYNc3dPointGroups            = #()
  global DYNc3dPipeNetworks           = #()
  global DYNc3dSites                  = #()
  global DYNmxPointStrings            = #()
  global DYNmxShapeStrings            = #()
  global DYNmxSurfaceStrings          = #()
  global DYN12dPointStrings           = #()
  global DYN12dShapeStrings           = #()
  global DYN12dSurfaceStrings         = #()
  global DYNxmlPointStrings           = #()
  global DYNxmlShapeStrings           = #()
  global DYNxmlSurfaceStrings         = #()

  global DYNopsLUP                    = [0,0] -- OPS Style Editor
  global DYNsosLUP                    = [0,0] -- SOS Style Editor
  global DYNrmsLUP                    = [0,0] -- RMS Style Editor
  global DYNrosLUP                    = [0,0] -- ROS Style Editor
  global DYNbosLUP                    = [0,0] -- BOS Style Editor
  global DYNfisLUP                    = [0,0] -- FIS Style Editor

  global DYNimpLUP                    = [0,0] -- Imported object manager
  global DYNplaLUP                    = [0,0] -- Placed object manager
  global DYNprfLUP                    = [0,0] -- Preferences panel
  global DYNprpLUP                    = [0,0] -- Properties panel
  global DYNexpLUP                    = [0,0] -- Explorer panel
  global DYNresLUP                    = [0,0] -- Resource manager

  global DYNxmlLUP                    = [0,0] -- LandXML import Panel
  global DYN12dLUP                    = [0,0] -- 12d import Panel
  global DYNgenLUP                    = [0,0] -- GENIO Import Panel
  global DYNdxfLUP                    = [0,0] -- Dxf Import Panel
  global DYNmxfLUP                    = [0,0] -- MX Import Panel
  global DYNc3dLUP                    = [0,0] -- Civil 3D Import Panel

  global DYNdefRLsizeOPS              = [547,740]
  global DYNdefRLsizeGEN              = [995,497]
  global DYNdefRLsizeMXM              = [995,497]
  global DYNdefRLsizeCVE              = [995,497]
  global DYNdefRLsize12D              = [995,497]
  global DYNdefRLsizeXML              = [995,497]
  global DYNdefRLsizeSOS              = [661,546]
  global DYNdefRLsizeRMS              = [823,401]
  global DYNdefRLsizeROS              = [695,386]
  global DYNdefRLsizeBOS              = [814,499]
  global DYNdefRLsizeFIS              = [915,554]
  global DYNdefRLsizeC3D              = [1080,725]
  global DYNdefRLsizeFSE              = [561,419]  -- File Selection Panel
  global DYNdefRLsizePLA              = [860,515]
  global DYNdefRLsizeIMP              = [800,400]

  global DYNfileSelectorFileName      = ""
  global DYNfileSelectorViewType      = 4
  global DYNfileSelectorSaveMode      = true
  global DYNfileSelectorKitMode       = 1
  global DYNfileSelectorKitLock       = false

  global DYNobjectPlacerViewType      = 4

  global DYNobjectSwitch              = 7
  global DYNlensSizes                 = #(     15,     20,     24,     28,     35,     50,     85,    135,    200)
  global DYNfovSizes                  = #(100.389, 83.974,  73.74,  65.47, 54.432, 39.598, 23.913, 15.189, 10.286) --Old pre-v2 lense sizes.
  /*global DYNfovSizes                = #( 67.696, 53.405, 45.484, 39.525, 32.072, 22.752, 13.499,  8.523,  5.759)*/  -- DO NOT CHANGE THIS LIST WITHOUT CONSIDERING THE EFFECT ON INI FILES FROM CAMERA OBJECT LIBRARY
  global DYNsosVtileDefault           = 10.0              -- uuu tiling default for materials on swept object elements
  global DYNsosUtileDefault           = 1.0               -- vee tiling default for materials on swept object elements
  global DYNtreeViewBkColor           = (color 255 255 255)
  global DYNpSystemPointLimit         = 1000
  global DYNdisplayOPSresourceKitSelector = true -- controls whether the resource kit selector panel is shown when opening OPS Editor (is suppressed when opened from FIS Editor)

  ---Function to check that required object plugins are loaded ----------------------
  fn DYNFUNcheckPlugins =
  (
    local LOCpluginSwitch = 0                           -- set a variable to hold status code to indicate which Civil View plugins are currently available to 3ds Max

    --- First check to see if DynSOS plugin is available - if not return 0 - if it is, check other plugins
    if classOf Civil_View_Swept_Object != UndefinedClass then
    (
      LOCpluginSwitch = 1

      --- Essential Plugins / Scripted Geometry
      local r = stringstream ""                         -- Initialise StringStream
      showClass "vsp*:geom*" to:r                       -- List Scripted Geometry Plugins
      r = r as string
      if (findString r "Vsp_Gantry :")   == undefined then LOCpluginSwitch = 0
      if (findString r "Vsp_GantrySA :") == undefined then LOCpluginSwitch = 0
      if (findString r "Vsp_GantryNZ :") == undefined then LOCpluginSwitch = 0
      if (findString r "Vsp_Tree :")     == undefined then LOCpluginSwitch = 0
      if (findString r "Vsp_Sign :")     == undefined then LOCpluginSwitch = 0
      if (findString r "Vsp_Signal :")   == undefined then LOCpluginSwitch = 0
      if (findString r "Vsp_Symb :")     == undefined then LOCpluginSwitch = 0
      if (findString r "Vsp_Lamp :")     == undefined then LOCpluginSwitch = 0

      --- Essential Plugins / Scripted Shapes
      local r = stringstream ""                         -- Initialise StringStream
      showClass "Civil*:shape*" to:r                    -- List Scripted Geometry Plugins
      r = r as string
      if (findString r "CivilView_Alignment :") == undefined then LOCpluginSwitch = 0
      if (findString r "CivilView_Pipe :") == undefined then LOCpluginSwitch = 0

      --- Other Essential Plugins / Scripted Geometry
      local r = stringstream ""                         -- Initialise StringStream
      showClass "Civil*:geom*" to:r                       -- List Scripted Geometry Plugins
      r = r as string
      if (findString r "Civil_Structure :")   == undefined then LOCpluginSwitch = 0

      --- Essential Plugins / Scripted Modifiers
      local r = stringstream ""                         -- Initialise StringStream
      showClass "dynbuilding:modi*" to:r                -- List Scripted Geometry Plugins
      r = r as string
      if (findString r "DynBuilding :")  == undefined then LOCpluginSwitch = 0

      --- Essential Plugins / SDK Based
      if DYNXFCC                     == undefined then LOCpluginSwitch = 0
      if DYNXFCCM3                   == undefined then LOCpluginSwitch = 0
      if DYNXFCCV3                   == undefined then LOCpluginSwitch = 0
      if Civil_View_Road_Marking     == undefined then LOCpluginSwitch = 0
      if Civil_View_Guard_Rail       == undefined then LOCpluginSwitch = 0
      if Civil_View_Spline_to_Mesh   == undefined then LOCpluginSwitch = 0
      if Civil_View_Divide_Spline    == undefined then LOCpluginSwitch = 0
      if Civil_View_Swept_Object    == undefined then LOCpluginSwitch = 0

      --- Optional Plugins - Forest Pro/Forest Lite Plugins (Check All Required Together)
      if LOCpluginSwitch == 1 then
      (
        if ((try forest_pro_3.category catch()) != undefined or (try forest_lite_3.category catch()) != undefined) and (try Forest_Material_3.category catch()) != undefined then
        (
          LOCpluginSwitch = 2
        )
      )
    )

    LOCpluginSwitch  -- Return value
  )

  --- Function for checking the validity of the VSP Main INI File - if it doesn't exist it will be created with default values
  --- then retrieves all global variable values based on Main VSP INI file keys
  fn DYNFUNcheckINIfile =
  (
    --- Create Reference to CivilView.ini (which may not exist yet)
    local LOCmainINIstream
    local LOCmainINIfile = (getdir #plugcfg) + "\\CivilView.ini"

    --- If the file does not yet exist, create it then check that it was created, and if so - close it.
    if not (doesFileExist LOCmainINIfile) then
      (
      LOCmainINIstream = createFile LOCmainINIfile
      if LOCmainINIstream != undefined then close LOCmainINIstream
    )

    --- If user CivilView.ini now exists, do some stuff...
    if doesFileExist LOCmainINIfile then
    (
      --- Set Root Civil View Paths before doing anything
      DYNscriptsPath     = (getdir #maxroot) + "stdplugs\\(CivilView)\\"
      DYNbinPath         = (getdir #maxroot) + "stdplugs\\(CivilView)\\bin\\"
      DYNiconsPath       = (getdir #maxroot) + "stdplugs\\(CivilView)\\Icons\\"
      DYNglobalMapsPath  = (getdir #maxroot) + "maps\\CivilView\\"
      DYNSkyMapPath      = (getdir #maxroot) + "maps\\CivilView\\SkyMaps\\"
      DYNtempPath        = sysInfo.tempDir

      --- See if a SkyMapPath override key can be found in Main INI File
      local LOCskyMapPath = getINIsetting LOCmainINIfile "General Settings" "SkyMapPath"
      if LOCskyMapPath != "" then
      (
        if (subString LOCskyMapPath LOCskyMapPath.count -1) != "\\" then LOCskyMapPath += "\\"
        DYNskyMapPath = LOCskyMapPath
      )

      --- Set Default Values for all INI file keys in CivilView.ini
      if (GetINISetting LOCmainINIfile "General Settings" "ExplorerWidth")     == "" then (setINISetting LOCmainINIfile "General Settings" "ExplorerWidth" "208")
      if (GetINISetting LOCmainINIfile "General Settings" "Distance")          == "" then (setINISetting LOCmainINIfile "General Settings" "Distance" "3") -- km
      if (GetINISetting LOCmainINIfile "General Settings" "Time")              == "" then (setINISetting LOCmainINIfile "General Settings" "Time" "4")     -- hour
      if (GetINIsetting LOCmainINIfile "General Settings" "MarkerSize")        == "" then (setINIsetting LOCmainINIfile "General Settings" "MarkerSize" "2")
      if (GetINIsetting LOCmainINIfile "General Settings" "FrameRate")         == "" then (setINIsetting LOCmainINIfile "General Settings" "FrameRate" "25")
      if (GetINIsetting LOCmainINIfile "General Settings" "3dsComPanel")       == "" then (setINIsetting LOCmainINIfile "General Settings" "3dsComPanel" "1")
      if (GetINIsetting LOCmainINIfile "General Settings" "DefaultMatChannel") == "" then (setINIsetting LOCmainINIfile "General Settings" "DefaultMatChannel" "27")
      if (GetINIsetting LOCmainINIfile "General Settings" "MatIDlimit")        == "" then (setINIsetting LOCmainINIfile "General Settings" "MatIDlimit" "500")
      if (GetINIsetting LOCmainINIfile "General Settings" "ResetMaxMenu")      == "" then (setINIsetting LOCmainINIfile "General Settings" "ResetMaxMenu" "1")
      if (GetINIsetting LOCmainINIfile "General Settings" "DisableGrid")       == "" then (setINIsetting LOCmainINIfile "General Settings" "DisableGrid" "0")
      if (GetINIsetting LOCmainINIfile "General Settings" "OverhangCorrect")   == "" then (setINIsetting LOCmainINIfile "General Settings" "OverhangCorrect" "1")
      if (GetINIsetting LOCmainINIfile "General Settings" "HideDiagonals")     == "" then (setINIsetting LOCmainINIfile "General Settings" "HideDiagonals" "1")
      if (GetINIsetting LOCmainINIfile "General Settings" "ShadowSaver")       == "" then (setINIsetting LOCmainINIfile "General Settings" "ShadowSaver" "0")
      if (GetINIsetting LOCmainINIfile "General Settings" "ChainageLoop")      == "" then (setINIsetting LOCmainINIfile "General Settings" "ChainageLoop" "1")
      if (GetINIsetting LOCmainINIfile "General Settings" "ProjectKit")        == "" then (setINIsetting LOCmainINIfile "General Settings" "ProjectKit" "0")
      if (GetINIsetting LOCmainINIfile "General Settings" "ProjectKitPath")    == "" then
      (
        if DYNdotNetSystemClass != undefined and DYNdotNetFolderClass != undefined then
        (
          setINIsetting LOCmainINIfile "General Settings" "ProjectKitPath" ((DYNdotNetSystemClass.getFolderPath DYNdotNetFolderClass.CommonApplicationData) + "\\Autodesk\\Civil View\\Project Resource Kits")
        )
        else
        (
          setINIsetting LOCmainINIfile "General Settings" "ProjectKitPath" ""
        )
      )
      if (GetINIsetting LOCmainINIfile (sysInfo.username) "AutoStart")         == "" then (setINIsetting LOCmainINIfile (sysInfo.username) "AutoStart" "0")
      if (GetINIsetting LOCmainINIfile (sysInfo.username) "PrivateKit")        == "" then (setINIsetting LOCmainINIfile (sysInfo.username) "PrivateKit" "0")
      if (GetINIsetting LOCmainINIfile (sysInfo.username) "PrivateKitPath") == "" then
      (
        if DYNdotNetSystemClass != undefined and DYNdotNetFolderClass != undefined then
        (
          setINIsetting LOCmainINIfile (sysInfo.username) "PrivateKitPath" ((DYNdotNetSystemClass.getFolderPath DYNdotNetFolderClass.MyDocuments) + "\\Civil View")
        )
        else
        (
          setINIsetting LOCmainINIfile (sysInfo.username) "PrivateKitPath" ""
        )
      )

      if (GetINIsetting LOCmainINIfile "General Settings" "retainOPSmat")           == "" then (setINIsetting LOCmainINIfile "General Settings" "retainOPSmat" "0")
      if (GetINIsetting LOCmainINIfile "General Settings" "showUnitsWarning")       == "" then (setINIsetting LOCmainINIfile "General Settings" "showUnitsWarning" "1")
      if (GetINIsetting LOCmainINIfile "General Settings" "showResourceKitWarning") == "" then (setINIsetting LOCmainINIfile "General Settings" "showResourceKitWarning" "1")
      if (GetINIsetting LOCmainINIfile "General Settings" "allowMultMarks")         == "" then (setINIsetting LOCmainINIfile "General Settings" "allowMultMarks" "0")
      if (GetINIsetting LOCmainINIfile "General Settings" "allowMultRails")         == "" then (setINIsetting LOCmainINIfile "General Settings" "allowMultRails" "0")
      if (GetINIsetting LOCmainINIfile "General Settings" "EnableFog")              == "" then (setINIsetting LOCmainINIfile "General Settings" "EnableFog" "0")
      if (GetINIsetting LOCmainINIfile "General Settings" "RotateWheels")           == "" then (setINIsetting LOCmainINIfile "General Settings" "RotateWheels" "1")
      if (GetINIsetting LOCmainINIfile "General Settings" "DockExplorer")           == "" then (setINIsetting LOCmainINIfile "General Settings" "DockExplorer" "0")
      if (GetINIsetting LOCmainINIfile "General Settings" "ShowIcons")              == "" then (setINIsetting LOCmainINIfile "General Settings" "ShowIcons" "1")
      if (GetINIsetting LOCmainINIfile "General Settings" "TreeVariation")          == "" then (setINIsetting LOCmainINIfile "General Settings" "TreeVariation" "15")
      if (GetINIsetting LOCmainINIfile "General Settings" "FaceSmoothing")          == "" then (setINIsetting LOCmainINIfile "General Settings" "FaceSmoothing" "9.0")

      if (GetINISetting LOCmainINIfile "Colors" "HighlightColor")                   == "" then (setINISetting LOCmainINIfile "Colors" "HighlightColor"   "(color 184 174 255)")
      if (GetINISetting LOCmainINIfile "Colors" "GreyedOutColor")                   == "" then (setINISetting LOCmainINIfile "Colors" "GreyedOutColor"   "(color 135 135 135)")
      if (GetINISetting LOCmainINIfile "Colors" "StartMarkerColor")                 == "" then (setINISetting LOCmainINIfile "Colors" "StartMarkerColor" "(color 0 255 0)")
      if (GetINISetting LOCmainINIfile "Colors" "EndMarkerColor")                   == "" then (setINISetting LOCmainINIfile "Colors" "EndMarkerColor"   "(color 255 0 0)")
      if (GetINISetting LOCmainINIfile "Colors" "RoadMarkingColor")                 == "" then (setINISetting LOCmainINIfile "Colors" "RoadMarkingColor" "(color 225 225 225)")

      if (GetINISetting LOCmainINIfile "Marking Line Settings"  "Spacing")          == "" then (setINISetting LOCmainINIfile "Marking Line Settings"  "Spacing"     "2.0")
      if (GetINISetting LOCmainINIfile "Marking Line Settings"  "Threshold")        == "" then (setINISetting LOCmainINIfile "Marking Line Settings"  "Threshold"   "0.5")
      if (GetINISetting LOCmainINIfile "Marking Line Settings"  "maxDistance")      == "" then (setINISetting LOCmainINIfile "Marking Line Settings"  "maxDistance" "25")

      if (GetINISetting LOCmainINIfile "General Settings"  "ImportHeap")            == "" then (setINISetting LOCmainINIfile "General Settings"  "ImportHeap" "50")

      --- Get/Set INI File Settings Relating to Traffic Import Functionality
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "Variablet")            == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "Variablet"           "t")
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "VariableVehNr")        == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "VariableVehNr"       "VehNr")
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "VariableVehTypeName")  == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "VariableVehTypeName" "VehTypeName")
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "VariableWorldX")       == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "VariableWorldX"      "WorldX")
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "VariableWorldY")       == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "VariableWorldY"      "WorldY")
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "VariableWorldZ")       == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "VariableWorldZ"      "WorldZ")
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "VariableRWorldX")      == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "VariableRWorldX"     "RWorldX")
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "VariableRWorldY")      == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "VariableRWorldY"     "RWorldY")
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "VariableRWorldZ")      == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "VariableRWorldZ"     "RWorldZ")
      if (getINIsetting LOCmainINIfile "FZP Variable Names" "VariableType")         == "" then (setINIsetting LOCmainINIfile "FZP Variable Names" "VariableType"        "Type")
      if (getINIsetting LOCmainINIfile "FZP Settings" "PreserveMemoryPercent")      == "" then (setINIsetting LOCmainINIfile "FZP Settings" "PreserveMemoryPercent" "20")
      if (getINIsetting LOCmainINIfile "FZP Settings" "ForceReadMethod")            == "" then (setINIsetting LOCmainINIfile "FZP Settings" "ForceReadMethod"        "0")
      if (getINIsetting LOCmainINIfile "FZP Settings" "StepThreshold")              == "" then (setINIsetting LOCmainINIfile "FZP Settings" "StepThreshold"          "2")


      --- Get Values from INI file and apply to VSP Global Variables
      local LOCspeedValue1       = (getINIsetting LOCmainINIfile "General Settings" "Distance")      as integer
      local LOCspeedValue2       = (getINIsetting LOCmainINIfile "General Settings" "Time")          as integer
      DYNINIspeedValue           = [LOCspeedValue1, LOCspeedValue2]
      DYNINImarkerSize           = (getINIsetting LOCmainINIfile "General Settings" "MarkerSize")    as integer
      DYNINIframeRate            = (getINIsetting LOCmainINIfile "General Settings" "FrameRate")     as integer
      DYNINIungpMatChan          = (getINIsetting LOCmainINIfile "General Settings" "DefaultMatChannel") as integer
      DYNINImatIDlimit           = (getINIsetting LOCmainINIfile "General Settings" "MatIDlimit")    as integer
      DYNINIminHeapSize          = (GetINISetting LOCmainINIfile "General Settings" "ImportHeap")    as integer
      DYNINItreeVariation        = (getINIsetting LOCmainINIfile "General Settings" "TreeVariation") as integer
      DYNINIfaceSmoothing        = (getINIsetting LOCmainINIfile "General Settings" "FaceSmoothing") as float

      DYNINIhighlightColor       = execute (getINIsetting LOCmainINIfile "Colors" "HighlightColor")
      DYNINIgreyedOutColor       = execute (getINIsetting LOCmainINIfile "Colors" "GreyedOutColor")
      DYNINIstartMarkerColor     = execute (getINIsetting LOCmainINIfile "Colors" "StartMarkerColor")
      DYNINIendMarkerColor       = execute (getINIsetting LOCmainINIfile "Colors" "EndMarkerColor")
      DYNINImarkingColor         = execute (getINIsetting LOCmainINIfile "Colors" "RoadMarkingColor")

      DYNINIexplorerWidth        = (getINIsetting LOCmainINIfile "General Settings" "ExplorerWidth") as integer; if DYNINIexplorerWidth < 208 then DYNINIexplorerWidth = 208
      DYNINIcomPanel             = getINIsetting LOCmainINIfile "General Settings" "3dsComPanel"
      DYNINIresetMaxMenu         = getINIsetting LOCmainINIfile "General Settings" "ResetMaxMenu"
      DYNINIdisableGrid          = getINIsetting LOCmainINIfile "General Settings" "DisableGrid"
      DYNINIoverhangCorrect      = getINIsetting LOCmainINIfile "General Settings" "OverhangCorrect"
      DYNINIhideDiagonals        = getINIsetting LOCmainINIfile "General Settings" "HideDiagonals"
      DYNINIshadowSaver          = getINIsetting LOCmainINIfile "General Settings" "ShadowSaver"
      DYNINIchainageLoop         = getINIsetting LOCmainINIfile "General Settings" "ChainageLoop"
      DYNINIprojectKit           = getINIsetting LOCmainINIfile "General Settings" "ProjectKit"
      DYNINIprojectKitPath       = GetINIsetting LOCmainINIfile "General Settings" "ProjectKitPath"

      if DYNINIprojectKitPath.count > 0 then
      (
        if (subString DYNINIprojectKitPath DYNINIprojectKitPath.count -1) != "\\" then DYNINIprojectKitPath += "\\"
      )

      DYNINIautoStart            = getINIsetting LOCmainINIfile (sysInfo.username) "AutoStart"
      DYNINIprivateKit           = getINIsetting LOCmainINIfile (sysInfo.username) "PrivateKit"
      DYNINIprivateKitPath       = GetINIsetting LOCmainINIfile (sysInfo.username) "PrivateKitPath"
      if DYNINIprivateKitPath.count > 0 then
      (
        if (subString DYNINIprivateKitPath DYNINIprivateKitPath.count -1) != "\\" then DYNINIprivateKitPath += "\\"
      )

      DYNINIretainOPSmat           = if (getINIsetting LOCmainINIfile "General Settings" "retainOPSmat") == "1" then true else false
      DYNINIshowUnitsWarning       = if (getINIsetting LOCmainINIfile "General Settings" "showUnitsWarning") == "1" then true else false
      DYNINIshowResourceKitWarning = if (getINIsetting LOCmainINIfile "General Settings" "showResourceKitWarning") == "1" then true else false
      DYNINIallowMultMarks         = if (getINIsetting LOCmainINIfile "General Settings" "allowMultMarks") == "1" then true else false
      DYNINIallowMultRails         = if (getINIsetting LOCmainINIfile "General Settings" "allowMultRails") == "1" then true else false
      DYNINIenableFog              = getINIsetting LOCmainINIfile "General Settings" "EnableFog"
      DYNINIrotateWheels           = getINIsetting LOCmainINIfile "General Settings" "RotateWheels"
      DYNINIdockExplorer           = getINIsetting LOCmainINIfile "General Settings" "DockExplorer"
      DYNINIshowIcons              = if (getINIsetting LOCmainINIfile "General Settings" "ShowIcons") == "1" then true else false

      DYNINImarkingSpacing         = (getINISetting LOCmainINIfile "Marking Line Settings" "Spacing") as float
      DYNINImarkingThreshold       = (getINISetting LOCmainINIfile "Marking Line Settings" "Threshold") as float
      DYNINImarkingMaxDistance     = (getINISetting LOCmainINIfile "Marking Line Settings" "maxDistance") as float



      --- Get Values from INI file and apply to Traffic Related Global Variables
      DYNINIt             = getINIsetting  LOCmainINIfile "FZP Variable Names" "Variablet"
      DYNINIvehNr         = getINIsetting  LOCmainINIfile "FZP Variable Names" "VariableVehNr"
      DYNINIvehTypeName   = getINIsetting  LOCmainINIfile "FZP Variable Names" "VariableVehTypeName"
      DYNINIworldX        = getINIsetting  LOCmainINIfile "FZP Variable Names" "VariableWorldX"
      DYNINIworldY        = getINIsetting  LOCmainINIfile "FZP Variable Names" "VariableWorldY"
      DYNINIworldZ        = getINIsetting  LOCmainINIfile "FZP Variable Names" "VariableWorldZ"
      DYNINIrWorldX       = getINIsetting  LOCmainINIfile "FZP Variable Names" "VariableRWorldX"
      DYNINIrWorldY       = getINIsetting  LOCmainINIfile "FZP Variable Names" "VariableRWorldY"
      DYNINIrWorldZ       = getINIsetting  LOCmainINIfile "FZP Variable Names" "VariableRWorldZ"
      DYNINItype          = getINIsetting  LOCmainINIfile "FZP Variable Names" "VariableType"
      DYNINImemPrecent    = (getINIsetting LOCmainINIfile "FZP Settings" "PreserveMemoryPercent") as integer
      DYNINIreadMethod    = (getINIsetting LOCmainINIfile "FZP Settings" "ForceReadMethod") as integer
      DYNINIstepThreshold = (getINIsetting LOCmainINIfile "FZP Settings" "StepThreshold") as integer

      --- Return value to be applied to DYNmainINI
      return LOCmainINIfile
    )
    else return undefined -- if file did not exist or could not be created for any reason, return {undefined} to DYNmainINI
  )

  fn DYNFUNcheckForValidCountryResourceKit FUNmainINIfile =
  (
    local LOCrtnValue = undefined
    if doesFileExist FUNmainINIfile then
    (
      -- Country Root Path will currently be set to the default path, but check Civil VIew INI file
      -- to see whether a path override key exists.  If it does, use this key as the Country Root Path
      local LOCcountryRootPath = getINIsetting FUNmainINIfile "General Settings" "CountryRootPath"
      if LOCcountryRootPath != "" then
      (
        if (subString LOCcountryRootPath LOCcountryRootPath.count -1) != "\\" then LOCcountryRootPath += "\\"
        DYNcountryRootPath = LOCcountryRootPath
      )

      -- Get List of Installed Country Resource Kits from current Country Root Path
      local LOCresKitsArray = DYNFUNgetCountryKits DYNcountryRootPath

      -- If no Country Resource Kit is currently selected, check that at least one kit exists in selected Country
      -- Root Path and then set that as current Country Resource Kit
      if LOCresKitsArray.count > 0 then
      (
        if (GetINISetting FUNmainINIfile "General Settings" "Country") == "" then
        (
          setINISetting FUNmainINIfile "General Settings" "Country" LOCresKitsArray[1]
        )
        LOCrtnValue = getINIsetting FUNmainINIfile "General Settings" "Country"
      )
      else LOCrtnValue = undefined
    )
    else LOCrtnValue = undefined

    LOCrtnValue -- return value
  )

  DYNdotNetSystemClass = dotNetClass "System.Environment"
  DYNdotNetFolderClass = dotNetClass "System.Environment+SpecialFolder"
  DYNpluginStatus      = DYNFUNcheckPlugins()
  DYNmainINI           = DYNFUNcheckINIfile()
  DYNINIcountry        = DYNFUNcheckForValidCountryResourceKit DYNmainINI
  DYNcountryExists     = if DYNINIcountry != undefined then (findItem (DYNFUNgetCountryKits DYNcountryRootPath) (DYNFUNupperCase DYNINIcountry 0)) else -1

  if DYNINIautoStart == "0" and not DYNforceManualStart then
  (
    local LOCmainMenuBar = DYNFUNremoveCivilViewFromMainMenu()

    --- Create Civil View Initialize Only Menu
    DynDVSPmenuMain      = menuMan.createMenu (DYNcivilViewProductName)
    local DYNmenuItem1 = menuMan.createActionItem  "MCRinitialize" "Civil View"
    DYNmenuItem1.setUseCustomTitle true
    DYNmenuItem1.setTitle  (DYNuiResourcesStartupScript[41])
    DynDVSPmenuMain.addItem DYNmenuItem1 -1

    --- Create a new Civil View menu item with the menu as it's sub-menu
    local DynDVSPmenuMainPosition = LOCmainMenuBar.numItems() - 3
    local DynDVSPmenuMainItem = menuMan.createSubMenuItem (DYNcivilViewProductName) DynDVSPmenuMain
    DynDVSPmenuMainItem.setUseCustomTitle true
    DynDVSPmenuMainItem.setTitle (DYNcivilViewProductName)
    LOCmainMenuBar.addItem DynDVSPmenuMainItem DynDVSPmenuMainPosition
    menuMan.updateMenuBar()
  )
  else
  (
    --- Commnce checks to see whether we can initialize Civil View
    if (DYNmainINI == undefined) or (DYNpluginStatus <= 0) or (DYNINIcountry == undefined) or (DYNcountryExists == 0) then
    (
      --- Display message to user to explain why Civil View could not even be initialized
      local LOCmessages = #()
      if DYNmainINI     == undefined then append LOCmessages DYNuiResourcesStartupScript[35]
      if DYNpluginStatus < 1         then append LOCmessages DYNuiResourcesStartupScript[36]
      if DYNINIcountry  == undefined then append LOCmessages DYNuiResourcesStartupScript[39]
      if DYNcountryExists == 0       then append LOCmessages DYNuiResourcesStartupScript[40] + "\n\n" + DYNcountryRootPath + DYNcountryKitFolderSeedName + " " + (DYNFUNupperCase DYNINIcountry 0) + "\n\n"

      local LOCmessage = LOCmessages[1]
      for i = 2 to LOCmessages.count do LOCmessage += "\n\n" + LOCmessages[i]

      messagebox LOCmessage title:DYNuiResourcesStartupScript[43] beep:true
    )
    else
    (
      --- Load Civil View .NET Components
      DYNdotNetExt                = dotNet.loadAssembly (DYNbinPath + "3am.DVSP.Extensions.dll")
      DYNdotNetDVSPctrls          = dotNet.loadAssembly (DYNbinPath + "3am.DVSP.Controls.dll")

      DYNdotNetCountryINIbase     = dotNetObject "ThreeAm.Core.Extensions.IniBase"
      DYNdotNetProjectINIbase     = dotNetObject "ThreeAm.Core.Extensions.IniBase"
      DYNdotNetPrivateINIbase     = dotNetObject "ThreeAm.Core.Extensions.IniBase"
      DYNdotNetFileBase           = dotNetObject "ThreeAm.Core.Extensions.FileUtils"
      DYNdnTvImageIcon            = dotNetClass  "System.Drawing.Image"

      --- Standard Large ImageList for Civil View
      DYNdnLgImageList            = dotNetObject "System.Windows.Forms.ImageList"
      DYNdnLgImageList.imageSize  = dotNetObject "System.Drawing.Size" 32 32
      DYNdnLgImageList.ColorDepth = (dotNetClass "System.Windows.Forms.ColorDepth").depth16bit
      DYNdnLgImageList.images.Clear()

      DYNdnLgImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "FileLarge.ico"))          -- 0
      DYNdnLgImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "WorldExplorer.ico"))      -- 1
      DYNdnLgImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Computer.ico"))           -- 2
      DYNdnLgImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "PrivateExplorer.ico"))    -- 3

      --- Standard Small ImageList for Civil View
      DYNdnSmImageList            = dotNetObject "System.Windows.Forms.ImageList"
      DYNdnSmImageList.imageSize  = dotNetObject "System.Drawing.Size" 16 16
      DYNdnSmImageList.ColorDepth = (dotNetClass "System.Windows.Forms.ColorDepth").depth8bit
      DYNdnSmImageList.images.Clear()

      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "FileSmall.ico"))          -- 0
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "vehicles.ico"))           -- 1
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "furniture.ico"))          -- 2
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "trees.ico"))              -- 3
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "signs.ico"))              -- 4
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "camera.ico"))             -- 5
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "primitives.ico"))         -- 6
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Feature_line.ico"))       -- 7
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Surface.ico"))            -- 8
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "swept.ico"))              -- 9
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "markings.ico"))           -- 10
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "forests.ico"))            -- 11
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "rail.ico"))               -- 12
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "buildings.ico"))          -- 13
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "PointSystem.ico"))        -- 14
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "PipeNetwork.ico"))        -- 15
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Alignment.ico"))          -- 16
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "shapes.ico"))             -- 17
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "geometry.ico"))           -- 18
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "camera.ico"))             -- 19
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "helper.ico"))             -- 20
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "wrench.ico"))             -- 21
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "mats.ico"))               -- 22
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "material.ico"))           -- 23
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "sky.ico"))                -- 24
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "lights.ico"))             -- 25
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "sun.ico"))                -- 26
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "dirtarg.ico"))            -- 27
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "omni.ico"))               -- 28
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "exposure.ico"))           -- 29
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "fog.ico"))                -- 30
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "lens.ico"))               -- 31
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Magnify.ico"))            -- 32
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Idea.ico"))               -- 33
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Lock.ico"))               -- 34
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Style.ico"))              -- 35
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "ObjectFile.ico"))         -- 36
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Folder.ico"))             -- 37
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "FolderOpen.ico"))         -- 38
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Information.ico"))        -- 39
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Drawing.ico"))            -- 40
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Corridor.ico"))           -- 41
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Assembly.ico"))           -- 42
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Baseline.ico"))           -- 43
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Globe.ico"))              -- 44
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "AreaFree.ico"))           -- 45
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "AreaTarg.ico"))           -- 46
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "DirFree.ico"))            -- 47
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "LinFree.ico"))            -- 48
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "LinTarg.ico"))            -- 49
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "SpotFree.ico"))           -- 50
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "SpotTarg.ico"))           -- 51
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Site.ico"))               -- 52
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Alignment.ico"))          -- 53
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "AssemblyOffset.ico"))     -- 54
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Subassembly.ico"))        -- 55
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Stylefolder.ico"))        -- 56
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "AlignmentCurbReturn.ico"))-- 57
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "AlignmentOffset.ico"))    -- 58
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "AlignmentUtility.ico"))   -- 59
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Profile.ico"))            -- 60
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Pipe.ico"))               -- 61
      DYNdnSmImageList.images.add (DYNdnTvIMageIcon.fromFile (DYNiconsPath + "Structure.ico"))          -- 62

      --- Standard Microsoft dotNet components
      DYNdnColorClass            = dotNetClass "System.Drawing.Color"
      DYNdnTabAlignClass         = dotNetclass "System.Windows.Forms.TabAlignment"
      DYNdnHorAlignClass         = dotNetclass "System.Windows.Forms.HorizontalAlignment"
      DYNdnmouseClass            = dotNetclass "System.Windows.Forms.MouseButtons"
      DYNdnDockClass             = dotNetclass "System.Windows.Forms.DockStyle"
      DYNdnSortOrderClass        = dotNetClass "System.Windows.Forms.SortOrder"
      DYNdnViewClass             = dotNetClass "System.Windows.Forms.View"
      DYNdnBorderStyleClass      = dotnetclass "System.Windows.Forms.BorderStyle"

      DYNdnStndFont              = dotNetObject "System.Drawing.Font" (dotNetObject "System.Drawing.FontFamily" "Tahoma") 8.25 (dotNetClass "system.drawing.fontStyle").regular
      DYNdnBoldFont              = dotNetObject "System.Drawing.Font" (dotNetObject "System.Drawing.FontFamily" "Tahoma") 8.25 (dotNetClass "system.drawing.fontStyle").bold

      --- Set Up Conditions for whether start can continue and whether a restart will be required
      local LOCuserStartupScript     = (getdir #userStartupScripts) + "\\CivilView.ms"
      local LOCpreventCivilViewStart = false
      local LOCaskUserToRestartMax   = false

        --- Display Main Initialization Panel ------------------------------------------

      if ((units.systemtype != #meters and units.systemtype != #feet) and DYNINIshowUnitsWarning) or DYNINIshowResourceKitWarning or (not (doesFileExist LOCuserStartupScript)) then
        (
          fn DYNFUNdisplayInitializationPanel FUNcaption FUNarray FUNpreSel =
          (
            local ExeStr=("rollout DYNrollout \"" + DYNuiResourcesStartupScript[12] + "\"\n")
            ExeStr+=("(\n")
            ExeStr+=("  local LOCresult = false\n")

            --- Panel Controls
            ExeStr+=("  button BUDYNokok width:120 pos:[323,462]\n")
            ExeStr+=("  button BUDYNcanc width:120 pos:[447,462]\n")

            --- For System Unit Settings
            ExeStr+=("  groupbox GBDYN01 height:178 width:555 pos:[12,13]\n")
            ExeStr+=("  listbox DDDYNunits width:150 pos:[22,35] height:9\n")
            ExeStr+=("  label LBDYNunitWarning pos:[182,35] align:#left width:355 height:133\n")
          ExeStr+=("  checkbox CKDYNsuppressWarning checked:true width:500 pos:[22,167]\n")

            --- For Country Kit Selection
            ExeStr+=("  groupbox GBDYN02 height:145 width:555 pos:[12,199]\n")
            ExeStr+=("  listbox DDDYNresKits width:150 pos:[22,221] height:8\n")
            ExeStr+=("  label LBDYNresourceKitQuery pos:[182,221] align:#left width:355 height:75\n")

            --- For Automatic or Manual Start
            ExeStr+=("  groupbox GBDYN03 height:100 width:555 pos:[12,352]\n")
            ExeStr+=("  listbox DDDYNautoStart width:150 pos:[22,374] height:4\n")
            ExeStr+=("  label LBDYNautoStart pos:[182,374] align:#left width:355 height:75\n")

            --- When Rollout Is Opened
            ExeStr+=("  on DYNrollout open do\n")
            ExeStr+=("  (\n")
            ExeStr+=("    GBDYN01.text               = DYNuiResourcesStartupScript[13]\n")
            ExeStr+=("    GBDYN02.text               = DYNuiResourcesStartupScript[14]\n")
            ExeStr+=("    GBDYN03.text               = DYNuiResourcesStartupScript[15]\n")
            ExeStr+=("    BUDYNokok.text             = DYNuiResourcesStartupScript[16]\n")
            ExeStr+=("    BUDYNcanc.text             = DYNuiResourcesStartupScript[17]\n")
            ExeStr+=("    LBDYNresourceKitQuery.text = DYNuiResourcesStartupScript[18] + \"\n\n\" + DYNuiResourcesStartupScript[34]\n")
            ExeStr+=("    LBDYNautoStart.text        = DYNuiResourcesStartupScript[19]\n")
            ExeStr+=("    DDDYNautoStart.items       = #(DYNuiResourcesStartupScript[20],DYNuiResourcesStartupScript[21])\n")
            ExeStr+=("    LBDYNunitWarning.text      = \"" + DYNuiResourcesStartupScript[22] + " " + (DYNFUNupperCase FUNcaption 1) + "\n\n" + DYNuiResourcesStartupScript[23] + "\n\n" + DYNuiResourcesStartupScript[24] + "\"\n")
            ExeStr+=("    CKDYNsuppressWarning.text  = DYNuiResourcesStartupScript[25]\n")
            ExeStr+=("    DDDYNunits.items           = #(DYNuiResourcesStartupScript[26], DYNuiResourcesStartupScript[27], DYNuiResourcesStartupScript[28], DYNuiResourcesStartupScript[29], DYNuiResourcesStartupScript[30], DYNuiResourcesStartupScript[31], DYNuiResourcesStartupScript[32])\n")

            ExeStr+=("    DDDYNunits.selection       = 6\n")
            ExeStr+=("    if units.systemtype == #Inches      then DDDYNunits.selection = 1 \n")
            ExeStr+=("    if units.systemtype == #Feet        then DDDYNunits.selection = 2 \n")
            ExeStr+=("    if units.systemtype == #Miles       then DDDYNunits.selection = 3 \n")
            ExeStr+=("    if units.systemtype == #Millimeters then DDDYNunits.selection = 4 \n")
            ExeStr+=("    if units.systemtype == #Centimeters then DDDYNunits.selection = 5 \n")
            ExeStr+=("    if units.systemtype == #Meters      then DDDYNunits.selection = 6 \n")
            ExeStr+=("    if units.systemtype == #Kilometers  then DDDYNunits.selection = 7 \n")

            if DYNINIautoStart == "1" then
            (
              ExeStr+=("  DDDYNautoStart.selection  = 2\n")
            )
            else
            (
              ExeStr+=("  DDDYNautoStart.selection  = 1\n")
            )

            -- For Country Kit Selection
            ExeStr+=("    DDDYNresKits.items = ")
            if FUNarray.count > 0 then
            (
              ExeStr+=("#(\"")
              for i = 1 to (FUNarray.count - 1) do (ExeStr+=((FUNarray[i] as string) + "\",\""))
              ExeStr+=((FUNarray[FUNarray.count] as string) + "\")")
            )
            ExeStr+=("   \n")
            ExeStr+=("    DDDYNresKits.selection     = " + (FUNpreSel as string) + "\n")
            ExeStr+=("  )\n")

          --- When Rollout Is Closed
            ExeStr+=("  on DYNrollout close do\n")
            ExeStr+=("  (\n")
          ExeStr+=("    if LOCresult then\n")
          ExeStr+=("    (\n")
            -- For Auto Start Settings
            ExeStr+=("    if DDDYNautoStart.selection == 1 then (DYNINIautoStart = \"0\"; setINIsetting DYNmainINI (sysInfo.username) \"AutoStart\" \"0\")\n")
            ExeStr+=("    if DDDYNautoStart.selection == 2 then (DYNINIautoStart = \"1\"; setINIsetting DYNmainINI (sysInfo.username) \"AutoStart\" \"1\")\n")
            -- For System Unit Settings
            ExeStr+=("    DYNINIshowUnitsWarning = CKDYNsuppressWarning.checked\n")
            ExeStr+=("    setINIsetting DYNmainINI \"General Settings\" \"showUnitsWarning\" (if CKDYNsuppressWarning.checked then \"0\" else \"1\")\n")
            ExeStr+=("    if DDDYNunits.selection > 0 then\n")
            ExeStr+=("    (\n")
            ExeStr+=("      if DDDYNunits.selection == 1 then (units.systemtype = #Inches     ; setINIsetting (getMAXiniFile()) \"Performance\" \"UnitType\" \"0\")\n")
            ExeStr+=("      if DDDYNunits.selection == 2 then (units.systemtype = #Feet       ; setINIsetting (getMAXiniFile()) \"Performance\" \"UnitType\" \"1\")\n")
            ExeStr+=("      if DDDYNunits.selection == 3 then (units.systemtype = #Miles      ; setINIsetting (getMAXiniFile()) \"Performance\" \"UnitType\" \"2\")\n")
            ExeStr+=("      if DDDYNunits.selection == 4 then (units.systemtype = #Millimeters; setINIsetting (getMAXiniFile()) \"Performance\" \"UnitType\" \"3\")\n")
            ExeStr+=("      if DDDYNunits.selection == 5 then (units.systemtype = #Centimeters; setINIsetting (getMAXiniFile()) \"Performance\" \"UnitType\" \"4\")\n")
            ExeStr+=("      if DDDYNunits.selection == 6 then (units.systemtype = #Meters     ; setINIsetting (getMAXiniFile()) \"Performance\" \"UnitType\" \"5\")\n")
            ExeStr+=("      if DDDYNunits.selection == 7 then (units.systemtype = #Kilometers ; setINIsetting (getMAXiniFile()) \"Performance\" \"UnitType\" \"6\")\n")
            ExeStr+=("    )\n")
            -- For Country Kit Selection
            ExeStr+=("    DYNINIshowResourceKitWarning = false\n")
            ExeStr+=("    setINIsetting DYNmainINI \"General Settings\" \"showResourceKitWarning\" \"0\"\n")
            ExeStr+=("    setINIsetting DYNmainINI \"General Settings\" \"Country\" DDDYNresKits.selected\n")
            ExeStr+=("    DYNINIcountry = getINIsetting DYNmainINI \"General Settings\" \"Country\"\n")
          -- Add Startup Script
          ExeStr+=("      local LOCuserStartupStream\n")
          ExeStr+=("      local LOCuserStartupScript = (getdir #userStartupScripts) + \"\\CivilView.ms\"\n")
          ExeStr+=("      if not (doesFileExist LOCuserStartupScript) then\n")
          ExeStr+=("      (\n")
          ExeStr+=("        LOCuserStartupStream = createFile LOCuserStartupScript\n")
          ExeStr+=("        if LOCuserStartupStream != undefined then\n")
          ExeStr+=("        (\n")
          ExeStr+=("          format \"fileIn @\\\"%\\\"\" (DYNscriptsPath + \"CivilViewStartup.ms\") to:LOCuserStartupStream\n")
          ExeStr+=("          close LOCuserStartupStream\n")
          ExeStr+=("        )\n")
          ExeStr+=("      )\n")
          ExeStr+=("    )\n")
            ExeStr+=("  )\n")
          -- UI control events
            ExeStr+=("  on BUDYNokok pressed do\n")
            ExeStr+=("  (\n")
            ExeStr+=("    LOCresult = true\n")
            ExeStr+=("    if (DDDYNunits.selection != 2 and DDDYNunits.selection != 6) then (if (queryBox (DYNuiResourcesStartupScript[33] + \" \" + (DDDYNunits.selected) + \"?\") title:DYNuiResourcesStartupScript[2]) then (destroyDialog DYNrollout)) else (destroyDialog DYNrollout)\n")
            ExeStr+=("  )\n")
            ExeStr+=("  on BUDYNcanc pressed do\n")
            ExeStr+=("  (\n")
            ExeStr+=("    LOCresult = false\n")
            ExeStr+=("    destroyDialog DYNrollout\n")
            ExeStr+=("  )\n")

            ExeStr+=(")\n")

            local DYNrollout = Execute ExeStr
            createDialog DYNrollout width:580 height:495 modal:true
            return DYNrollout.LOCresult
          )

          local LOCresKitArray  = DYNFUNgetCountryKits DYNcountryRootPath
        local LOCwasInitialized  = DYNFUNdisplayInitializationPanel (units.systemtype as string) LOCresKitArray (findItem LOCresKitArray (DYNFUNupperCase DYNINIcountry 0))

        --- Check Status of 3dsmax.ini key. If this needs to be set to "1", a restart of 3ds Max is required
        local LOColdCivilViewStartedStatus = getINISetting (getMAXIniFile()) "CivilView" "CivilViewStarted"
        if LOColdCivilViewStartedStatus != "1" then
        (
          -- Set the 3dsmax.ini CivilViewStarted key to "1" which affects isPublic status of Civil View plugins
          setINISetting (getMAXIniFile()) "CivilView" "CivilViewStarted" "1"

          -- If INI key was set, Civil View should not be allowed to start. If the user did not bail
          -- out of the Initialization Panel, a restart is now going to be required.
          LOCpreventCivilViewStart = true

          -- If Initialization Panel was closed without clicking the "OK" button, we ssume that the user does
          -- not even want to start Civil View, do absolutely nothing.
          -- On the other hand, if the OK was clicked and INI key was set, we must ask the user to restart 3ds Max
          LOCaskUserToRestartMax   = if LOCwasInitialized then true else false
        )
        else
        (
          -- If INI key was not changed, Civil View is allowed to start
          LOCpreventCivilViewStart = false

          -- If INI key was not changed, there is no need to ask user to restart 3ds Max
          -- even though other initialization variables may have been modified
          LOCaskUserToRestartMax   = false
        )
      )


      --- Switch which decides whether Civil View startup is allowed to continue
      if LOCpreventCivilViewStart then
      (
        if LOCaskUserToRestartMax then
        (
          -- If 3ds Max Needs to be restarted, display a message to the user now
        DYNFUNremoveCivilViewFromMainMenu()
          messagebox (DYNuiResourcesStartupScript[3]) title:DYNuiResourcesStartupScript[2]
        )
      )
      else
        (
          global DYNuiResourcesFileTypes = #( \
            ~GLOB_FILETYPE_12DA~, \                   -- 01
            ~GLOB_FILETYPE_GENIO~, \                  -- 02
            ~GLOB_FILETYPE_MODEL~, \                  -- 03
            ~GLOB_FILETYPE_LANDXML~, \                -- 04
            ~GLOB_FILETYPE_VSP3D~, \                  -- 05
            ~GLOB_FILETYPE_FZP~, \                    -- 06
            ~GLOB_FILETYPE_SIM~, \                    -- 07
            ~GLOB_FILETYPE_TXT~, \                    -- 08
            ~GLOB_FILETYPE_SCRIPT~, \                 -- 09
            ~GLOB_FILETYPE_MX_INPUT~, \               -- 10
            ~GLOB_FILETYPE_IMPORT~, \                 -- 11
            ~GLOB_FILETYPE_RESOURCE~ \                -- 12
          )

          global DYNuiResourcesC3dObjectTypes = #( \
            ~C3D_OBJTYPE_CENTRELINE_ALIGNMENT~, \     -- 01
            ~C3D_OBJTYPE_OFFSET_ALIGNMENT~, \         -- 02
            ~C3D_OBJTYPE_CORNER_ALIGNMENT~, \         -- 03
            ~C3D_OBJTYPE_MISC_ALIGNMENT~, \           -- 04
            ~C3D_OBJTYPE_CORR_BL~, \                  -- 05
            ~C3D_OBJTYPE_CORR_OFFSET_BL~, \           -- 06
            ~C3D_OBJTYPE_CORR_FL~, \                  -- 07
            ~C3D_OBJTYPE_CORR_OFFSET_FL~, \           -- 08
            ~C3D_OBJTYPE_CORR_SURFACE~, \             -- 09
            ~C3D_OBJTYPE_CORR_OFFSET_SURFACE~, \      -- 10
            ~C3D_OBJTYPE_POINT_GROUP~, \              -- 11
            ~C3D_OBJTYPE_PIPE_NETWORK~, \             -- 12
            ~C3D_OBJTYPE_SURFACE~, \                  -- 13
            ~C3D_OBJTYPE_LANDFEATURELINE~, \          -- 14
            ~C3D_OBJTYPE_BASELINE~, \                 -- 15
            ~C3D_OBJTYPE_REGION~, \                   -- 16
            ~C3D_OBJTYPE_ALIGNMENT~, \                -- 17
            ~C3D_OBJTYPE_ALIGNMENTS~, \               -- 18
            ~C3D_OBJTYPE_CENTRELINE_ALIGNMENTS~, \    -- 19
            ~C3D_OBJTYPE_OFFSET_ALIGNMENTS~, \        -- 20
            ~C3D_OBJTYPE_CORNER_ALIGNMENTS~, \        -- 21
            ~C3D_OBJTYPE_MISC_ALIGNMENTS~, \          -- 22
            ~C3D_OBJTYPE_SURFACES~, \                 -- 23
            ~C3D_OBJTYPE_POINT_GROUPS~, \             -- 24
            ~C3D_OBJTYPE_PIPE_NETWORKS~, \            -- 25
            ~C3D_OBJTYPE_SITES~, \                    -- 26
            ~C3D_OBJTYPE_CORRIDORS~ \                 -- 27
          )

          global DYNuiResourcesPsystemClasses = #( \
            ~PSYSTEM_CLASS_NONE~, \                   -- 01
            ~PSYSTEM_CLASS_BOUNDING_BOX~, \           -- 02
            ~PSYSTEM_CLASS_GEOMETRY~, \               -- 03
            ~PSYSTEM_CLASS_PHANTOM~, \                -- 04
            ~PSYSTEM_CLASS_DOT~, \                    -- 05
            ~PSYSTEM_CLASS_TICK~, \                   -- 06
            ~PSYSTEM_CLASS_CIRCLE~, \                 -- 07
            ~PSYSTEM_CLASS_LINE~, \                   -- 08
            ~PSYSTEM_CLASS_DIAMOND~, \                -- 09
            ~PSYSTEM_CLASS_BOX~, \                    -- 10
            ~PSYSTEM_CLASS_ASTERISK~, \               -- 11
            ~PSYSTEM_CLASS_TRIANGLE~ \                -- 12
          )

          global DYNuiResourcesPreferences = #( \
            ~PREF_STATUS_INSTRUCTIONS~, \             -- 01
            ~PREF_ROLLOUT_TITLE~, \                   -- 02
            ~PREF_QUERY_APPLY_FRAME_RATE~, \          -- 03
            ~PREF_TAB_GENERAL~, \                     -- 04
            ~PREF_TAB_LOCALIZATION~, \                -- 05
            ~PREF_TAB_COLORS~, \                      -- 06
            ~PREF_TAB_RESOURCE_PATHS~, \              -- 07
            ~PREF_TAB_MATERIALS~, \                   -- 08
            ~PREF_TAB_IMPORT~, \                      -- 09
            ~PREF_GRP_SKY_MAP_FOLDER~, \              -- 10
            ~PREF_GRP_ANIMATION_UNITS~, \             -- 11
            ~PREF_GRP_COUNTRY_RESOURCE_FOLDER~, \     -- 12
            ~PREF_GRP_PROJECT_RESOURCE_FOLDER~, \     -- 13
            ~PREF_GRP_PRIVATE_RESOURCE_FOLDER~, \     -- 14
            ~PREF_GRP_SURFACES_MATERIAL_DEFAULTS~, \  -- 15
            ~PREF_GRP_MATERIALS_GENERAL~, \           -- 16
            ~PREF_GRP_GENERAL_IMPORT_OPTIONS~, \      -- 17
            ~PREF_GRP_CIVIL3D_IMPORT_OPTOINS~, \      -- 18
            ~PREF_LABEL_ENABLE_FOG~, \                -- 19
            ~PREF_LABEL_FRAME_RATE~, \                -- 20
            ~PREF_LABEL_EXPLORER_DOCKED~, \           -- 21
            ~PREF_LABEL_CHECKBUTTON_COLOR~, \         -- 22
            ~PREF_LABEL_GRAYED_COLOR~, \              -- 23
            ~PREF_LABEL_START_MARKER_COLOR~, \        -- 24
            ~PREF_LABEL_END_MARKER_COLOR~, \          -- 25
            ~PREF_LABEL_MARKER_SIZE~, \               -- 26
            ~PREF_LABEL_STATION_LOOPING~, \           -- 27
            ~PREF_LABEL_MARKINGS_COLOR~, \            -- 28
            ~PREF_LABEL_EXPLORER_WIDTH~, \            -- 29
            ~PREF_LABEL_RETAIN_COMMAND_PANEL~, \      -- 30
            ~PREF_LABEL_RELOAD_MENUS~, \              -- 31
            ~PREF_LABEL_DISABLE_GRID~, \              -- 32
            ~PREF_LABEL_DEFAULT_MATID~, \             -- 33
            ~PREF_LABEL_TREE_VARIATION~, \            -- 34
            ~PREF_LABEL_SHOW_ICONS~, \                -- 35
            ~PREF_LABEL_SKY_MAP_FOLDER~, \            -- 36
            ~PREF_LABEL_SELECT_COUNTRY_FOLDER~, \     -- 37
            ~PREF_LABEL_SELECT_PROJECT_FOLDER~, \     -- 38
            ~PREF_LABEL_SELECT_PRIVATE_FOLDER~, \     -- 39
            ~PREF_LABEL_ACTIVE_RESOURCE_KIT~, \       -- 40
            ~PREF_LABEL_DISTANCE_UNITS~, \            -- 41
            ~PREF_LABEL_TIME_UNITS~, \                -- 42
            ~PREF_LABEL_FACE_SMOOTHING~, \            -- 43
            ~PREF_LABEL_OVERHANG_CORRECTION~, \       -- 44
            ~PREF_LABEL_HIDE_DIAGONALS~, \            -- 45
            ~PREF_LABEL_OVERRIDE_MATERIALS~, \        -- 46
            ~PREF_LABEL_AUTO_START~, \                -- 47
            ~PREF_LABEL_ALLOW_MULTIPLE_MARKINGS~, \   -- 48
            ~PREF_LABEL_ALLOW_MULTIPLE_RAILS~, \      -- 49
            ~PREF_LABEL_MATID_LIMIT~, \               -- 50
            ~PREF_LABEL_NO_PROJECT_KIT~, \            -- 51
            ~PREF_LABEL_USE_SCENE_FOLDER~, \          -- 52
            ~PREF_LABEL_USE_SPECIFIC_FOLDER~, \       -- 53
            ~PREF_LABEL_USE_PRIVATE~, \               -- 54
            ~PREF_LABEL_ROTATE_WHEELS~ \              -- 55
          )

          global DYNuiResourcesSightTool = #( \
            ~SIGHTTOOL_CATEGORY_01~, \                -- 01
            ~SIGHTTOOL_CATEGORY_02~, \                -- 02
            ~SIGHTTOOL_CATEGORY_03~, \                -- 03
            ~SIGHTTOOL_CATEGORY_04~, \                -- 04
            ~SIGHTTOOL_CATEGORY_05~, \                -- 05
            ~SIGHTTOOL_CATEGORY_06~, \                -- 06
            ~SIGHTTOOL_CATEGORY_07~, \                -- 07
            ~SIGHTTOOL_CATEGORY_08~, \                -- 08
            ~SIGHTTOOL_CATEGORY_09~, \                -- 09
            ~SIGHTTOOL_CATEGORY_10~, \                -- 10
            ~SIGHTTOOL_CATEGORY_11~, \                -- 11
            ~SIGHTTOOL_CATEGORY_12~, \                -- 12
            ~SIGHTTOOL_CATEGORY_13~, \                -- 13
            ~SIGHTTOOL_CATEGORY_14~, \                -- 14
            ~SIGHTTOOL_CATEGORY_15~, \                -- 15
            ~SIGHTTOOL_CATEGORY_16~, \                -- 16
            ~SIGHTTOOL_CATEGORY_17~, \                -- 17
            ~SIGHTTOOL_CATEGORY_18~, \                -- 18
            ~SIGHTTOOL_CATEGORY_19~, \                -- 19
            ~SIGHTTOOL_CATEGORY_20~, \                -- 20
            ~SIGHTTOOL_DISPLAY_PROGRESS~, \           -- 21
            ~SIGHTTOOL_CROSS_HAIRS~, \                -- 22
            ~SIGHTTOOL_TARGET_OUTLINE~, \             -- 23
            ~SIGHTTOOL_FILL_TARGET~, \                -- 24
            ~SIGHTTOOL_ADD_WATERMARK~, \              -- 25
            ~SIGHTTOOL_TEXT_BACKGROUN~, \             -- 26
            ~SIGHTTOOL_ALPHA_BLEND~, \                -- 27
            ~SIGHTTOOL_OUTPUT_ANALYSIS~, \            -- 28
            ~SIGHTTOOL_TRANSFER_01~, \                -- 29
            ~SIGHTTOOL_TRANSFER_02~, \                -- 30
            ~SIGHTTOOL_TRANSFER_03~, \                -- 31
            ~SIGHTTOOL_TRANSFER_04~, \                -- 32
            ~SIGHTTOOL_TRANSFER_05~, \                -- 33
            ~SIGHTTOOL_TRANSFER_06~, \                -- 34
            ~SIGHTTOOL_TRANSFER_07~, \                -- 35
            ~SIGHTTOOL_TRANSFER_08~, \                -- 36
            ~SIGHTTOOL_TRANSFER_09~, \                -- 37
            ~SIGHTTOOL_LABEL_01~, \                   -- 38
            ~SIGHTTOOL_LABEL_02~, \                   -- 39
            ~SIGHTTOOL_LABEL_03~, \                   -- 40
            ~SIGHTTOOL_LABEL_04~, \                   -- 41
            ~SIGHTTOOL_LABEL_05~, \                   -- 42
            ~SIGHTTOOL_LABEL_06~, \                   -- 43
            ~SIGHTTOOL_LABEL_07~, \                   -- 44
            ~SIGHTTOOL_LABEL_08~, \                   -- 45
            ~SIGHTTOOL_LABEL_09~, \                   -- 46
            ~SIGHTTOOL_LABEL_10~, \                   -- 47
            ~SIGHTTOOL_LABEL_11~, \                   -- 48
            ~SIGHTTOOL_LABEL_12~, \                   -- 49
            ~SIGHTTOOL_LABEL_13~, \                   -- 50
            ~SIGHTTOOL_LABEL_14~ \                    -- 51
          )

          global DYNuiResourcesForest = #( \
            ~FORST_GRP_PLACEMENT~, \                  -- 01
            ~FORST_GRP_LOOK_AT~, \                    -- 02
            ~FORST_GRP_TREE_PARAMS~, \                -- 03
            ~FORST_GRP_TREE_TYPE~, \                  -- 04
            ~FORST_LABEL_LIMIT_VIS~, \                -- 05
            ~FORST_LABEL_FACE_CAMERA~, \              -- 06
            ~FORST_BUTTON_INCL_BDRY~, \               -- 07
            ~FORST_BUTTON_EXCL_BDRY~, \               -- 08
            ~FORST_BUTTON_SURFACE~, \                 -- 09
            ~FORST_LABEL_CAMERA~, \                   -- 10
            ~FORST_LABEL_HEIGHT~, \                   -- 11
            ~FORST_LABEL_WIDTH~, \                    -- 12
            ~FORST_LABEL_HEIGHT_VARIATION~, \         -- 13
            ~FORST_LABEL_WIDTH_VARIATION~, \          -- 14
            ~FORST_LABEL_PLANES~, \                   -- 15
            ~FORST_LABEL_LOCK_ASPECT~, \              -- 16
            ~FORST_BUTTON_OTHER_DEFINITIONS~, \       -- 17
            ~FORST_LABEL_ONE_PLANE~, \                -- 18
            ~FORST_LABEL_TWO_PLANES~ \                -- 19
          )

          global DYNuiResourcesUndoLabels = #( \
            ~GLOB_UNDO_FOG_CHANGE~, \                 -- 01
            ~GLOB_UNDO_STATION_CHANGE~, \             -- 02
            ~GLOB_UNDO_H_OFFSET_CHANGE~, \            -- 03
            ~GLOB_UNDO_V_OFFSET_CHANGE~, \            -- 04
            ~GLOB_UNDO_ROTATION_CHANGE~, \            -- 05
            ~GLOB_UNDO_CAMERA_TARGET~, \              -- 06
            ~GLOB_UNDO_CAMERA_TILT~, \                -- 07
            ~GLOB_UNDO_VEHICLE_PARAMETER~, \          -- 08
            ~GLOB_UNDO_TREE_PARAMETER~, \             -- 09
            ~GLOB_UNDO_SET_PARTICLES~, \              -- 10
            ~GLOB_UNDO_PRIMITIVE_CHANGE~, \           -- 11
            ~GLOB_UNDO_SIGN_PARAMETER~, \             -- 12
            ~GLOB_UNDO_SIGNAL_PARAMETER~, \           -- 13
            ~GLOB_UNDO_GANTRY_PARAMETER~, \           -- 14
            ~GLOB_UNDO_REMOVE_KEYS~, \                -- 15
            ~GLOB_UNDO_REVERSE_KEYS~, \               -- 16
            ~GLOB_UNDO_SCALE_KEYS~, \                 -- 17
            ~GLOB_UNDO_ADD_KEYS~, \                   -- 18
            ~GLOB_UNDO_CREATE_PARTICLES~ \            -- 19
          )

          global DYNuiResourcesErrorsWarnings = #( \
            ~GLOB_ERRORS_WARNINGS_HELP_UNAVAILABLE~, \-- 01
            ~GLOB_ERRORS_WARNINGS_FOREST_MISSING~, \  -- 02
            ~GLOB_ERRORS_WARNINGS_FIXED_FORMAT~, \    -- 03
            ~GLOB_ERRORS_WARNINGS_NOT_VALID_SHAPE~, \ -- 04
            ~GLOB_ERRORS_WARNINGS_RESTART_REQUIRED~, \-- 05
            ~GLOB_ERRORS_WARNINGS_NO_IMAGE_FILES~, \  -- 06
            ~GLOB_ERRORS_WARNINGS_NO_RESOURCE_KITS~, \-- 07
            ~GLOB_ERRORS_WARNINGS_CREATING_KIT~, \    -- 08
            ~GLOB_ERRORS_WARNINGS_DUPL_MATID_A~, \    -- 09
            ~GLOB_ERRORS_WARNINGS_DUPL_MATID_B~, \    -- 10
            ~GLOB_ERRORS_WARNINGS_MOVE_ELEMENT~, \    -- 11
            ~GLOB_ERRORS_WARNINGS_DELETE_ELEMENT~, \  -- 12
            ~GLOB_ERRORS_WARNINGS_SHAPE_SELECTED~, \  -- 13
            ~GLOB_ERRORS_WARNINGS_NO_ELEMENTS~, \     -- 14
            ~GLOB_ERRORS_WARNINGS_NO_BOS_ELEMENTS~, \ -- 15
            ~GLOB_ERRORS_WARNINGS_OUTPUT_ERROR~, \    -- 16
            ~GLOB_ERRORS_WARNINGS_EMPTY_FIS_STYLE~, \ -- 17
            ~GLOB_ERRORS_WARNINGS_INVALID_WILDCARD~, \-- 18
            ~GLOB_ERRORS_WARNINGS_NOTHING_SELECTED~, \-- 19
            ~GLOB_ERRORS_WARNINGS_READING_FILE~, \    -- 20
            ~GLOB_ERRORS_WARNINGS_NO_GEOMETRY~, \     -- 21
            ~GLOB_ERRORS_WARNINGS_POSITIVE_SHIFT~, \  -- 22
            ~GLOB_ERRORS_WARNINGS_NEGATIVE_SHIFT~, \  -- 23
            ~GLOB_ERRORS_WARNINGS_RES_KIT_NOT_FOUND~,\-- 24
            ~GLOB_ERRORS_WARNINGS_REBUILD_MAT~, \     -- 25
            ~GLOB_ERRORS_WARNINGS_RESET_MAT~, \       -- 26
            ~GLOB_ERRORS_WARNINGS_INVALID_MATERIAL~, \-- 27
            ~GLOB_ERRORS_WARNINGS_NO_MULTISUBOBJ~, \  -- 28
            ~GLOB_ERRORS_WARNINGS_INVALID_MATID~, \   -- 29
            ~GLOB_ERRORS_WARNINGS_BITMAP_DISPLAY~, \  -- 30
            ~GLOB_ERRORS_WARNINGS_SUN_LOCATION~, \    -- 31
            ~GLOB_ERRORS_WARNINGS_ATTACH_TO_SELF~, \  -- 32
            ~GLOB_ERRORS_WARNINGS_ATTACH_TO_HOST~, \  -- 33
            ~GLOB_ERRORS_WARNINGS_ALREADY_ATTACHED~, \-- 34
            ~GLOB_ERRORS_WARNINGS_NO_LONGER_LINKED~, \-- 35
            ~GLOB_ERRORS_WARNINGS_FILE_EXISTS~, \     -- 36
            ~GLOB_ERRORS_WARNINGS_FILE_NOT_FOUND~, \  -- 37
            ~GLOB_ERRORS_WARNINGS_FILE_NOT_DELETED~, \-- 38
            ~GLOB_ERRORS_WARNINGS_FILE_IS_READONLY~, \-- 39
            ~GLOB_ERRORS_WARNINGS_EMPTY_SHAPE_LIST~, \-- 40
            ~GLOB_ERRORS_WARNINGS_MISSING_MULTIMAT~, \-- 41
            ~GLOB_ERRORS_WARNINGS_MULTIPLE_SPLINES~, \-- 42
            ~GLOB_ERRORS_WARNINGS_INVALID_SURFACE_A~,\-- 43
            ~GLOB_ERRORS_WARNINGS_INVALID_SHAPE~, \   -- 44
            ~GLOB_ERRORS_WARNINGS_SPANNING_MODE~, \   -- 45
            ~GLOB_ERRORS_WARNINGS_SEPARATED_MODE~, \  -- 46
            ~GLOB_ERRORS_WARNINGS_OBJECT_DETACHED~, \ -- 47
            ~GLOB_ERRORS_WARNINGS_INVALID_OBJECT~, \  -- 48
            ~GLOB_ERRORS_WARNINGS_SELECT_SURFACES~, \ -- 49
            ~GLOB_ERRORS_WARNINGS_SELECT_VEHICLES~, \ -- 50
            ~GLOB_ERRORS_WARNINGS_INVALID_KEYS~, \    -- 51
            ~GLOB_ERRORS_WARNINGS_NO_SELECTED_FACES~,\-- 52
            ~GLOB_ERRORS_WARNINGS_NO_VEHICLES~, \     -- 53
            ~GLOB_ERRORS_WARNINGS_END_TIME_ERROR~, \  -- 54
            ~GLOB_ERRORS_WARNINGS_GENERAL_ERROR~, \   -- 55
            ~GLOB_ERRORS_WARNINGS_FZP_FIELDS~, \      -- 56
            ~GLOB_ERRORS_WARNINGS_ANIMATION_LENGTH~, \-- 57
            ~GLOB_ERRORS_WARNINGS_INVALID_VEHICLE~, \ -- 58
            ~GLOB_ERRORS_WARNINGS_NO_SELECTED_ITEMS~,\-- 59
            ~GLOB_ERRORS_WARNINGS_NO_LONGER_LISTED~, \-- 60
            ~GLOB_ERRORS_WARNINGS_IMPORT_ERROR~, \    -- 61
            ~GLOB_ERRORS_WARNINGS_NO_DXF_FILES~, \    -- 62
            ~GLOB_ERRORS_WARNINGS_INVALID_BONUS~, \   -- 63
            ~GLOB_ERRORS_WARNINGS_SAVE_MAT_LIBRARY~, \-- 64
            ~GLOB_ERRORS_WARNINGS_MATERIAL_SAVED~, \  -- 65
            ~GLOB_ERRORS_WARNINGS_NO_ROS_ELEMENTS~, \ -- 66
            ~GLOB_ERRORS_WARNINGS_NO_RMS_ELEMENTS~, \ -- 67
            ~GLOB_ERRORS_WARNINGS_NO_OPS_ELEMENTS~, \ -- 68
            ~GLOB_ERRORS_WARNINGS_CANNOT_APPLY_FIS~, \-- 69
            ~GLOB_ERRORS_WARNINGS_NO_MATCH_STYLES~, \ -- 70
            ~GLOB_ERRORS_WARNINGS_INVALID_STYLE~, \   -- 71
            ~GLOB_ERRORS_WARNINGS_STYLE_NOT_FOUND~, \ -- 72
            ~GLOB_ERRORS_WARNINGS_PLACEMENT_ERROR~, \ -- 73
            ~GLOB_ERRORS_WARNINGS_SPLINE_COUNT~, \    -- 74
            ~GLOB_ERRORS_WARNINGS_PROFILE_LIMIT~, \   -- 75
            ~GLOB_ERRORS_WARNINGS_INVALID_SOS~, \     -- 76
            ~GLOB_ERRORS_WARNINGS_CREATE_INPUTFILE~, \-- 77
            ~GLOB_ERRORS_WARNINGS_ALREADY_SOS~, \     -- 78
            ~GLOB_ERRORS_WARNINGS_EQUAL_SPLINES~, \   -- 79
            ~GLOB_ERRORS_WARNINGS_SELECT_ALT~, \      -- 80
            ~GLOB_ERRORS_WARNINGS_SOS_PARENT1~, \     -- 81
            ~GLOB_ERRORS_WARNINGS_SOS_PARENT2~, \     -- 82
            ~GLOB_ERRORS_WARNINGS_NO_PROFILE~, \      -- 83
            ~GLOB_ERRORS_WARNINGS_UPDATE_OBJECTS~, \  -- 84
            ~GLOB_ERRORS_WARNINGS_DELETE_OBJECTS~, \  -- 85
            ~GLOB_ERRORS_WARNINGS_NOT_COMPATIBLE~, \  -- 86
            ~GLOB_ERRORS_WARNINGS_INI_READ_ONLY~, \   -- 87
            ~GLOB_ERRORS_WARNINGS_ILLEGAL_COMMAS~, \  -- 88
            ~GLOB_ERRORS_WARNINGS_ALREADY_EXISTS~, \  -- 89
            ~GLOB_ERRORS_WARNINGS_INI_OUT_OF_STEP~, \ -- 90
            ~GLOB_ERRORS_WARNINGS_TOO_MANY_OBJECTS~, \-- 91
            ~GLOB_ERRORS_WARNINGS_OPS_ERROR1~, \      -- 92
            ~GLOB_ERRORS_WARNINGS_OPS_ERROR2~, \      -- 93
            ~GLOB_ERRORS_WARNINGS_INITIAL_SETTINGS~, \-- 94
            ~GLOB_ERRORS_WARNINGS_DOES_NOT_EXIST~, \  -- 95
            ~GLOB_ERRORS_WARNINGS_REFERENCE_BLANK~, \ -- 96
            ~GLOB_ERRORS_WARNINGS_OBJECTS_UPDATED~, \ -- 97
            ~GLOB_ERRORS_WARNINGS_OTHERS_UPDATED~, \  -- 98
            ~GLOB_ERRORS_WARNINGS_SOURCE_INVALID~, \  -- 99
            ~GLOB_ERRORS_WARNINGS_MULTIPLE_UPDATE~, \ -- 100
            ~GLOB_ERRORS_WARNINGS_SOURCE_LOCATED~, \  -- 101
            ~GLOB_ERRORS_WARNINGS_REPORT_FILE~, \     -- 102
            ~GLOB_ERRORS_WARNINGS_SOURCE_NOT_FOUND~, \-- 103
            ~GLOB_ERRORS_WARNINGS_FIRST_MISSING~, \   -- 104
            ~GLOB_ERRORS_WARNINGS_INVALID_SOURCE~, \  -- 105
            ~GLOB_ERRORS_WARNINGS_INVALID_VSP3D~, \   -- 106
            ~GLOB_ERRORS_WARNINGS_INVALID_POINTS~, \  -- 107
            ~GLOB_ERRORS_WARNINGS_INVALID_SURFACE_B~,\-- 108
            ~GLOB_ERRORS_WARNINGS_INI_FILE_UPDATED~, \-- 109
            ~GLOB_ERRORS_WARNINGS_INI_FILE_RENAMED~, \-- 110
            ~GLOB_ERRORS_WARNINGS_INI_FILE_COPIED~, \ -- 111
            ~GLOB_ERRORS_WARNINGS_BEARING~, \         -- 112
            ~GLOB_ERRORS_WARNINGS_COPY_SUCCESSFUL~, \ -- 113
            ~GLOB_ERRORS_WARNINGS_LOAD_TO_MATERIAL~, \-- 114
            ~GLOB_ERRORS_WARNINGS_COPY_FAILED~, \     -- 115
            ~GLOB_ERRORS_WARNINGS_NO_FACES_FOUND~, \  -- 116
            ~GLOB_ERRORS_WARNINGS_INVALID_INFO~, \    -- 117
            ~GLOB_ERRORS_WARNINGS_OPS_STYLE_ERROR1~, \-- 118
            ~GLOB_ERRORS_WARNINGS_OPS_STYLE_ERROR2~, \-- 119
            ~GLOB_ERRORS_WARNINGS_OPS_STYLE_ERROR3~, \-- 120
            ~GLOB_ERRORS_WARNINGS_OPS_STYLE_ERROR4~, \-- 121
            ~GLOB_ERRORS_WARNINGS_OPS_STYLE_ERROR5~, \-- 122
            ~GLOB_ERRORS_WARNINGS_INVALID_BITMAP~, \  -- 123
            ~GLOB_ERRORS_WARNINGS_WORLD_FILE_FOUND~, \-- 124
            ~GLOB_ERRORS_WARNINGS_FOREST_SHAPE_01~, \ -- 125
            ~GLOB_ERRORS_WARNINGS_FOREST_SHAPE_02~, \ -- 126
            ~GLOB_ERRORS_WARNINGS_OPENING_FIS_STYLE~,\-- 127
            ~GLOB_ERRORS_WARNINGS_FIS_STYLE_01~, \    -- 128
            ~GLOB_ERRORS_WARNINGS_FIS_STYLE_02~, \    -- 129
            ~GLOB_ERRORS_WARNINGS_MOVE_RENAME_FILE~, \-- 130
            ~GLOB_ERRORS_WARNINGS_COPY_FAILURE~, \    -- 131
            ~GLOB_ERRORS_WARNINGS_SOURCE_TARG_SAME~, \-- 132
            ~GLOB_ERRORS_WARNINGS_NO_FILES_FOUND~, \  -- 133
            ~GLOB_ERRORS_WARNINGS_NO_PIPE_NETWORK~ \  -- 134
          )

          global DYNuiResourcesQueries = #( \
            ~GLOB_QUERIES_PERMANENTLY_DELETE~, \      -- 01
            ~GLOB_QUERIES_COLLAPSE_STACK~, \          -- 02
            ~GLOB_QUERIES_SAVE_STYLE~, \              -- 03
            ~GLOB_QUERIES_CONFIRM_DETACH~, \          -- 04
            ~GLOB_QUERIES_ARE_YOU_SURE~, \            -- 05
            ~GLOB_QUERIES_CLOSE_PANEL~, \             -- 06
            ~GLOB_QUERIES_SETUP_PROJ_RESKIT~, \       -- 07
            ~GLOB_QUERIES_DISCARD_CHANGES~, \         -- 08
            ~GLOB_QUERIES_DISCARD_RESET~, \           -- 09
            ~GLOB_QUERIES_UNLINK~, \                  -- 10
            ~GLOB_QUERIES_COLLAPSE~, \                -- 11
            ~GLOB_QUERIES_DELETE_FACES~, \            -- 12
            ~GLOB_QUERIES_MATID_FACES~, \             -- 13
            ~GLOB_QUERIES_TILING_FACES~, \            -- 14
            ~GLOB_QUERIES_DISPLAY_BITMAP~, \          -- 15
            ~GLOB_QUERIES_ADD_MATID~, \               -- 16
            ~GLOB_QUERIES_ANIMATE_ROTATION~, \        -- 17
            ~GLOB_QUERIES_REMOVE_ROTATION~, \         -- 18
            ~GLOB_QUERIES_ANIMATE_VERTICAL~, \        -- 19
            ~GLOB_QUERIES_REMOVE_ALL_VERTICAL_KEYS~, \-- 20
            ~GLOB_QUERIES_ANIMATE_HORIZ~, \           -- 21
            ~GLOB_QUERIES_REMOVE_HORIZ_KEYS~, \       -- 22
            ~GLOB_QUERIES_ANIMATE_STATION~, \         -- 23
            ~GLOB_QUERIES_REMOVE_ALL_STATION_KEYS~, \ -- 24
            ~GLOB_QUERIES_BAKE_XYZ~, \                -- 25
            ~GLOB_QUERIES_DELETE_FILE~, \             -- 26
            ~GLOB_QUERIES_REMOVE_DEPENDENCIES~, \     -- 27
            ~GLOB_QUERIES_COLLAPSE_TO_MESH~, \        -- 28
            ~GLOB_QUERIES_PARENTSHAPE_SPLINEMODE~, \  -- 29
            ~GLOB_QUERIES_DELETE_TEMP_OBJECTS~, \     -- 30
            ~GLOB_QUERIES_TIME_WARNING~, \            -- 31
            ~GLOB_QUERIES_EXTEND_ANIMATION~, \        -- 32
            ~GLOB_QUERIES_NO_UNDO_AREYOUSURE~, \      -- 33
            ~GLOB_QUERIES_FURTHER_DETAILS~, \         -- 34
            ~GLOB_QUERIES_IMPORT_SHIFT_PROCEED~, \    -- 35
            ~GLOB_QUERIES_IMPORT_SHIFT_INFO~, \       -- 36
            ~GLOB_QUERIES_DELETE_CATEGORY~, \         -- 37
            ~GLOB_QUERIES_DELETE_LIGHTS~, \           -- 38
            ~GLOB_QUERIES_DELETE_DEPENDENCIES~, \     -- 39
            ~GLOB_QUERIES_COLLAPSE_CATEGORY~, \       -- 40
            ~GLOB_QUERIES_MAT_LIBRARY_EXISTS~, \      -- 41
            ~GLOB_QUERIES_REMOVE_EFECTS~, \           -- 42
            ~GLOB_QUERIES_USE_AS_PARENT~, \           -- 43
            ~GLOB_QUERIES_USE_MANUALLY~, \            -- 44
            ~GLOB_QUERIES_UPDATE_OBJECTS~, \          -- 45
            ~GLOB_QUERIES_CHANGE_SOURCE_FEATURE~, \   -- 46
            ~GLOB_QUERIES_CHANGE_SOURCE_FILE~, \      -- 47
            ~GLOB_QUERIES_CONSTANT_SPEED~, \          -- 48
            ~GLOB_QUERIES_STATION_LOOPING_ON~, \      -- 49
            ~GLOB_QUERIES_STATION_LOOPING_OFF~, \     -- 50
            ~GLOB_QUERIES_SHAPE_TRACKING_ON~, \       -- 51
            ~GLOB_QUERIES_SHAPE_TRACKING_OFF~, \      -- 52
            ~GLOB_QUERIES_LONGFALL_TRACKING_ON~, \    -- 53
            ~GLOB_QUERIES_LONGFALL_TRACKING_OFF~, \   -- 54
            ~GLOB_QUERIES_SURFACE_TRACKING_ON~, \     -- 55
            ~GLOB_QUERIES_SURFACE_TRACKING_OFF~, \    -- 56
            ~GLOB_QUERIES_BOUNDING_BOX_ON~, \         -- 57
            ~GLOB_QUERIES_BOUNDING_BOX_OFF~, \        -- 58
            ~GLOB_QUERIES_REVERSE_ALL_KEYS~, \        -- 59
            ~GLOB_QUERIES_REVERSE_STATION_KEYS~, \    -- 60
            ~GLOB_QUERIES_REVERSE_HORIZONTAL_KEYS~, \ -- 61
            ~GLOB_QUERIES_REVERSE_VERTICAL_KEYS~, \   -- 62
            ~GLOB_QUERIES_REVERSE_ROTATION_KEYS~, \   -- 63
            ~GLOB_QUERIES_SCALE_ALL_KEYS~, \          -- 64
            ~GLOB_QUERIES_SCALE_STATION_KEYS~, \      -- 65
            ~GLOB_QUERIES_SCALE_HORIZONTAL_KEYS~, \   -- 66
            ~GLOB_QUERIES_SCALE_VERTICAL_KEYS~, \     -- 67
            ~GLOB_QUERIES_SCALE_ROTATION_KEYS~, \     -- 68
            ~GLOB_QUERIES_REMOVE_ALL_KEYS~, \         -- 69
            ~GLOB_QUERIES_REMOVE_STATION_KEYS~, \     -- 70
            ~GLOB_QUERIES_REMOVE_HORIZONTAL_KEYS~, \  -- 71
            ~GLOB_QUERIES_REMOVE_VERTICAL_KEYS~, \    -- 72
            ~GLOB_QUERIES_REMOVE_ROTATION_KEYS~, \    -- 73
            ~GLOB_QUERIES_REMOVE_PREVIEW_FILE~, \     -- 74
            ~GLOB_QUERIES_REMOVE_OPACITY_MAP~, \      -- 75
            ~GLOB_QUERIES_USE_ALPHA_CHANNEL~, \       -- 76
            ~GLOB_QUERIES_CONFIRM_COPY_FILE~, \       -- 77
            ~GLOB_QUERIES_CONFIRM_MOVE_FILE~, \       -- 78
            ~GLOB_QUERIES_RETAIN_OBJECTS~, \          -- 79
            ~GLOB_QUERIES_SWITCH_PARENT_SHAPE~, \     -- 80
            ~GLOB_QUERIES_INTERP_REMINDER_A~, \       -- 81
            ~GLOB_QUERIES_INITIAL_SETTINGS~, \        -- 82
            ~GLOB_QUERIES_SETUP_RESOURCE_KIT1~, \     -- 83
            ~GLOB_QUERIES_INTERP_REMINDER_B~, \       -- 84
            ~GLOB_QUERIES_SUGGESTED_GLOBAL_SHIFT~, \  -- 85
            ~GLOB_QUERIES_CALCULATED_GLOBAL_SHIFT~, \ -- 86
            ~GLOB_QUERIES_START_BEARING_TOOL~, \      -- 87
            ~GLOB_QUERIES_COPY_TO_RESOURCE_KIT~, \    -- 88
            ~GLOB_QUERIES_FILE_EXISTS_OVERWRITE~, \   -- 89
            ~GLOB_QUERIES_UPDATE_ENTIRE_NETWORK~ \    -- 90
          )

          global DYNuiResourcesTooltips = #( \
            ~GLOB_TOOLTIP_FLIP_NORMALS~, \            -- 01
            ~GLOB_TOOLTIP_REMOVE_SMOOTHING~, \        -- 02
            ~GLOB_TOOLTIP_DELETE_SELECTED~, \         -- 03
            ~GLOB_TOOLTIP_START_NEW_STYLE~, \         -- 04
            ~GLOB_TOOLTIP_OPEN_STYLE~, \              -- 05
            ~GLOB_TOOLTIP_SAVE_STYLE~, \              -- 06
            ~GLOB_TOOLTIP_ADD_ELEMENT~, \             -- 07
            ~GLOB_TOOLTIP_DELETE_ELEMENT~, \          -- 08
            ~GLOB_TOOLTIP_MOVE_ELEMENT_UP~, \         -- 09
            ~GLOB_TOOLTIP_MOVE_ELEMENT_DOWN~, \       -- 10
            ~GLOB_TOOLTIP_CUT_ELEMENT~, \             -- 11
            ~GLOB_TOOLTIP_COPY_ELEMENT~, \            -- 12
            ~GLOB_TOOLTIP_PASTE_ELEMENT~, \           -- 13
            ~GLOB_TOOLTIP_RESET~, \                   -- 14
            ~GLOB_TOOLTIP_MULTIPLE_MARKINGS~, \       -- 15
            ~GLOB_TOOLTIP_MAT_ASSIGNMENT~, \          -- 16
            ~GLOB_TOOLTIP_IMPORT_FROM_SHAPE~, \       -- 17
            ~GLOB_TOOLTIP_VEHICLE_ID~, \              -- 18
            ~GLOB_TOOLTIP_AGGRESSION~, \              -- 19
            ~GLOB_TOOLTIP_AWARENESS~, \               -- 20
            ~GLOB_TOOLTIP_IS_FAMILIAR~, \             -- 21
            ~GLOB_TOOLTIP_PETURBATION_VALUE~, \       -- 22
            ~GLOB_TOOLTIP_STATION_LOOPING_STATUS~, \  -- 23
            ~GLOB_TOOLTIP_LIBRARY_CONTENT_STYLE~, \   -- 24
            ~GLOB_TOOLTIP_RESET_PLACED_OBJECTS~, \    -- 25
            ~GLOB_TOOLTIP_PICK_PARENT_SHAPE~, \       -- 26
            ~GLOB_TOOLTIP_PICK_PARENT_SURFACE~, \     -- 27
            ~GLOB_TOOLTIP_WHEEL_ROTATION_OVERRIDE~ \  -- 28
          )

          global DYNuiResourcesStatusMessages = #( \
            ~GLOB_STATUS_INITIALIZING~, \             -- 01
            ~GLOB_STATUS_PLEASE_WAIT~, \              -- 02
            ~GLOB_STATUS_NUMBER_OF_IMPORTED_OBJS~, \  -- 03
            ~GLOB_STATUS_GATHERING_OPS_STYLE~, \      -- 04
            ~GLOB_STATUS_IMPORTING~, \                -- 05
            ~GLOB_STATUS_SELECT_FILES~, \             -- 06
            ~GLOB_STATUS_CHOOSE_LOCATION~, \          -- 07
            ~GLOB_STATUS_UPDATING_OBJECTS~, \         -- 08
            ~GLOB_STATUS_COUNT_OBJECTS_SELECTED~, \   -- 09
            ~GLOB_STATUS_CREATING_MARKINGS~, \        -- 10
            ~GLOB_STATUS_CREATION_COMPLETED~, \       -- 11
            ~GLOB_STATUS_CREATE_OR_LOAD_RMS~, \       -- 12
            ~GLOB_STATUS_CREATING_BUILDINGS~, \       -- 13
            ~GLOB_STATUS_CREATE_OR_LOAD_BOS~, \       -- 14
            ~GLOB_STATUS_CREATE_OR_LOAD_SOS~, \       -- 15
            ~GLOB_STATUS_SELECT_IMPORT_FILE~, \       -- 16
            ~GLOB_STATUS_APPLYING_FIS~, \             -- 17
            ~GLOB_STATUS_GEO_DATA~, \                 -- 18
            ~GLOB_STATUS_PRS_CONTROLLER~, \           -- 19
            ~GLOB_STATUS_COLLAPSE_TO_MESH~, \         -- 20
            ~GLOB_STATUS_STATION_CREATION~, \         -- 21
            ~GLOB_STATUS_TEXT_CREATED~, \             -- 22
            ~GLOB_STATUS_STATION_TEXT_PROGRESS~, \    -- 23
            ~GLOB_STATUS_PLACING_OBJECTS~, \          -- 24
            ~GLOB_STATUS_SELECT_CLONE_SOURCE~, \      -- 25
            ~GLOB_STATUS_SELECT_VEHICLE_LIST~, \      -- 26
            ~GLOB_STATUS_SURFACE_TRACKING~, \         -- 27
            ~GLOB_STATUS_TRACKING_COMPLETE~, \        -- 28
            ~GLOB_STATUS_SUBSTITUTING_VEHICLE~, \     -- 29
            ~GLOB_STATUS_SELECT_VEHICLE~, \           -- 30
            ~GLOB_STATUS_IMPORT_COMPLETE~, \          -- 31
            ~GLOB_STATUS_GENERATING_TRAFFIC~, \       -- 32
            ~GLOB_STATUS_READING_FZP_FILE~, \         -- 33
            ~GLOB_STATUS_COUNT_OBJECTS_EXIST~, \      -- 34
            ~GLOB_STATUS_COUNT_OBJECTS_LISTED~, \     -- 35
            ~GLOB_STATUS_OPTIMIZING_FACES~, \         -- 36
            ~GLOB_STATUS_READING_OBJECTS~, \          -- 37
            ~GLOB_STATUS_CONVERTING_SELECTED~, \      -- 38
            ~GLOB_STATUS_READING_SELECTED~, \         -- 39
            ~GLOB_STATUS_SCANNING_MODEL~, \           -- 40
            ~GLOB_STATUS_NO_VALID_DATA~, \            -- 41
            ~GLOB_STATUS_SELECT_STRINGS~, \           -- 42
            ~GLOB_STATUS_CREATING_RAILS~, \           -- 43
            ~GLOB_STATUS_CREATED_RAILS~, \            -- 44
            ~GLOB_STATUS_LOAD_ROS_STYLE~, \           -- 45
            ~GLOB_STATUS_LOAD_FIS_STYLE~, \           -- 46
            ~GLOB_STATUS_CREATING_SWEPT~, \           -- 47
            ~GLOB_STATUS_CREATED_SWEPT~, \            -- 48
            ~GLOB_STATUS_SHAPE_CONVERSION~, \         -- 49
            ~GLOB_STATUS_CONVERSION_COMPLETE~, \      -- 50
            ~GLOB_STATUS_PLACEMENT_COMPLETE~, \       -- 51
            ~GLOB_STATUS_APPLYING_FIS_TO~, \          -- 52
            ~GLOB_STATUS_COUNT_OBJECTS_IMPORTED~, \   -- 53
            ~GLOB_STATUS_VEHICLES_FOUND~, \           -- 54
            ~GLOB_STATUS_FOUND_ELEMENT~, \            -- 55
            ~GLOB_STATUS_COUNTRY_KIT~, \              -- 56
            ~GLOB_STATUS_PROJECT_KIT~, \              -- 57
            ~GLOB_STATUS_PRIVATE_KIT~, \              -- 58
            ~GLOB_STATUS_LOAD_OPS~, \                 -- 59
            ~GLOB_STATUS_OBJECTS_CREATED~, \          -- 60
            ~GLOB_STATUS_PROCESSING_OPS_ELEMENT~, \   -- 61
            ~GLOB_STATUS_UPDATE_CONTROLLERS~, \       -- 62
            ~GLOB_STATUS_OBJECTS_UPDATED~, \          -- 63
            ~GLOB_STATUS_CHECKING_SOURCE~, \          -- 64
            ~GLOB_STATUS_UPDATING_IMPORTED~, \        -- 65
            ~GLOB_STATUS_IMPORTING_MX_SHAPES~, \      -- 66
            ~GLOB_STATUS_IMPORTING_MX_POINTS~, \      -- 67
            ~GLOB_STATUS_IMPORTING_MX_TINS~, \        -- 68
            ~GLOB_STATUS_IMPORTING_12D_SHAPES~, \     -- 69
            ~GLOB_STATUS_IMPORTING_12D_POINTS~, \     -- 70
            ~GLOB_STATUS_IMPORTING_12D_TINS~, \       -- 71
            ~GLOB_STATUS_IMPORTING_ALIGNMENTS~, \     -- 72
            ~GLOB_STATUS_IMPORTING_CORRIDOR_SURF~, \  -- 73
            ~GLOB_STATUS_IMPORTING_CORRIDOR_FLS~, \   -- 74
            ~GLOB_STATUS_IMPORTING_SURFACES~, \       -- 75
            ~GLOB_STATUS_IMPORTING_POINT_GROUPS~, \   -- 76
            ~GLOB_STATUS_IMPORTING_PIPE_NETWORKS~, \  -- 77
            ~GLOB_STATUS_IMPORTING_SITE_FLS~, \       -- 78
            ~GLOB_STATUS_IMPORTING_LANDXML_TINS~, \   -- 79
            ~GLOB_STATUS_IMPORTING_LANDXML_SHAPES~, \ -- 80
            ~GLOB_STATUS_IMPORTING_LANDXML_POINTS~ \  -- 81
          )

          global DYNuiResourcesTitlebars = #( \
            ~GLOB_TITLEBAR_ERROR~, \                  -- 01
            ~GLOB_TITLEBAR_WARNING~, \                -- 02
            ~GLOB_TITLEBAR_INFO~, \                   -- 03
            ~GLOB_TITLEBAR_SELECT_VSP3D_FILE~, \      -- 04
            ~GLOB_TITLEBAR_SELECT_GENIO_FILE~, \      -- 05
            ~GLOB_TITLEBAR_SELECT_MODEL_FILE~, \      -- 06
            ~GLOB_TITLEBAR_SELECT_12DA_FILE~, \       -- 07
            ~GLOB_TITLEBAR_SELECT_FZP_FILE~, \        -- 08
            ~GLOB_TITLEBAR_SELECT_SIM_FILE~, \        -- 09
            ~GLOB_TITLEBAR_SELECT_OUTPUT_FILE~, \     -- 10
            ~GLOB_TITLEBAR_SELECT_SOURCE_FILE~, \     -- 11
            ~GLOB_TITLEBAR_SELECT_PROJ_RESKIT~, \     -- 12
            ~GLOB_TITLEBAR_SELECT_BITMAP_CHANNEL~, \  -- 13
            ~GLOB_TITLEBAR_RENAME_OBJECT~, \          -- 14
            ~GLOB_TITLEBAR_MODIFY_MATID~, \           -- 15
            ~GLOB_TITLEBAR_FACE_SMOOTHING~, \         -- 16
            ~GLOB_TITLEBAR_SURFACE_EDITOR~, \         -- 17
            ~GLOB_TITLEBAR_SELECT_BITMAP~, \          -- 18
            ~GLOB_TITLEBAR_SELECT_SIGN~, \            -- 19
            ~GLOB_TITLEBAR_SELECT_TREE~, \            -- 20
            ~GLOB_TITLEBAR_SELECT_MARKING_SYMBOL~, \  -- 21
            ~GLOB_TITLEBAR_APPLY_ANIMATION~, \        -- 22
            ~GLOB_TITLEBAR_SAVE_AS~, \                -- 23
            ~GLOB_TITLEBAR_OPEN~, \                   -- 24
            ~GLOB_TITLEBAR_OPEN_STYLE~, \             -- 25
            ~GLOB_TITLEBAR_SAVE_STYLE~, \             -- 26
            ~GLOB_TITLEBAR_IMPORT_STYLE~, \           -- 27
            ~GLOB_TITLEBAR_NEW_FILE_NAME~, \          -- 28
            ~GLOB_TITLEBAR_PICK_SHAPE_BY_NAME~, \     -- 29
            ~GLOB_TITLEBAR_SURFACE_TRACKING~, \       -- 30
            ~GLOB_TITLEBAR_TIME_RESOLUTION~, \        -- 31
            ~GLOB_TITLEBAR_MAKE_SELECTION~, \         -- 32
            ~GLOB_TITLEBAR_ERROR_REPORT~, \           -- 33
            ~GLOB_TITLEBAR_SELECT_WATERMARK~, \       -- 34
            ~GLOB_TITLEBAR_SOS_TO_INPUTFILE~, \       -- 35
            ~GLOB_TITLEBAR_ASSIGN_MATERIAL~, \        -- 36
            ~GLOB_TITLEBAR_SOURCE_ASSOCIATION~, \     -- 37
            ~GLOB_TITLEBAR_SCALE_ANIMATION~, \        -- 38
            ~GLOB_TITLEBAR_AMEND_OFFSET~, \           -- 39
            ~GLOB_TITLEBAR_AMEND_ROTATION~, \         -- 40
            ~GLOB_TITLEBAR_RANDOM_OFFSET~, \          -- 41
            ~GLOB_TITLEBAR_RANDOM_ROTATION~, \        -- 42
            ~GLOB_TITLEBAR_RELATIVE_STATION~, \       -- 43
            ~GLOB_TITLEBAR_SPLINE_INDEX~, \           -- 44
            ~GLOB_TITLEBAR_QUICK_PLACEMENT~, \        -- 45
            ~GLOB_TITLEBAR_SELECT_XML_FILE~, \        -- 46
            ~GLOB_TITLEBAR_NEW_GROUP_NAME~, \         -- 47
            ~GLOB_TITLEBAR_NEW_DIFFUSE_MAP~, \        -- 48
            ~GLOB_TITLEBAR_NEW_OPACITY_MAP~, \        -- 49
            ~GLOB_TITLEBAR_NEW_PREVIEW_MAP~, \        -- 50
            ~GLOB_TITLEBAR_NEW_SOURCE_FILE~, \        -- 51
            ~GLOB_TITLEBAR_NEW_LENS_SIZE~, \          -- 52
            ~GLOB_TITLEBAR_PRIMITIVE_TYPE~, \         -- 53
            ~GLOB_TITLEBAR_SELECT_PANEL_MODE~, \      -- 54
            ~GLOB_TITLEBAR_RESOURCE_KIT_SETUP~, \     -- 55
            ~GLOB_TITLEBAR_SAVE_TO_TXT~, \            -- 56
            ~GLOB_TITLEBAR_REPORT_ALIGNMENT~, \       -- 57
            ~GLOB_TITLEBAR_REPORT_SHAPE~, \           -- 58
            ~GLOB_TITLEBAR_CONFIGURING~ \             -- 59
          )

          global DYNuiResourcesButtons = #( \
            ~GLOB_BUTTON_OK~, \                       -- 01
            ~GLOB_BUTTON_APPLY~, \                    -- 02
            ~GLOB_BUTTON_CANCEL~, \                   -- 03
            ~GLOB_BUTTON_OPTIONS~, \                  -- 04
            ~GLOB_BUTTON_HELP~, \                     -- 05
            ~GLOB_BUTTON_OPEN~, \                     -- 06
            ~GLOB_BUTTON_CLOSE~, \                    -- 07
            ~GLOB_BUTTON_SAVE~, \                     -- 08
            ~GLOB_BUTTON_EDIT_STYLE~, \               -- 09
            ~GLOB_BUTTON_NEW_STYLE~, \                -- 10
            ~GLOB_BUTTON_ADD~, \                      -- 11
            ~GLOB_BUTTON_REMOVE~, \                   -- 12
            ~GLOB_BUTTON_RESET~, \                    -- 13
            ~GLOB_BUTTON_UPDATE~, \                   -- 14
            ~GLOB_BUTTON_UNDEFINED~, \                -- 15
            ~GLOB_BUTTON_SELECT_ALL~, \               -- 16
            ~GLOB_BUTTON_SELECT_NONE~, \              -- 17
            ~GLOB_BUTTON_APPLY_FILTER~, \             -- 18
            ~GLOB_BUTTON_REMOVE_FILTER~, \            -- 19
            ~GLOB_BUTTON_PARENT_SHAPE~, \             -- 20
            ~GLOB_BUTTON_PARENT_SURFACE~, \           -- 21
            ~GLOB_BUTTON_REMOVE_X~, \                 -- 22
            ~GLOB_BUTTON_PICK_SHAPE_LABEL~, \         -- 23
            ~GLOB_BUTTON_INHERIT_ALT_PARAMS~, \       -- 24
            ~GLOB_BUTTON_LINKED~, \                   -- 25
            ~GLOB_BUTTON_UNLINKED~, \                 -- 26
            ~GLOB_BUTTON_INSTANCES_EXIST~, \          -- 27
            ~GLOB_BUTTON_ADVANCED~, \                 -- 28
            ~GLOB_BUTTON_REFRESH~, \                  -- 29
            ~GLOB_BUTTON_ON~, \                       -- 30
            ~GLOB_BUTTON_OFF~, \                      -- 31
            ~GLOB_BUTTON_CHOOSE_BITMAP~,\             -- 32
            ~GLOB_BUTTON_CHOOSE_FOLDER~, \            -- 33
            ~GLOB_BUTTON_DISPLAY_IN_VIEWPORT~, \      -- 34
            ~GLOB_BUTTON_DELETE~, \                   -- 35
            ~GLOB_BUTTON_RESET_R~, \                  -- 36
            ~GLOB_BUTTON_NO_INSTANCES_EXIST~, \       -- 37
            ~GLOB_BUTTON_CREATE_MULTISPLINE~, \       -- 38
            ~GLOB_BUTTON_PICK_PARENT_SHAPE~, \        -- 39
            ~GLOB_BUTTON_EDIT_E~, \                   -- 40
            ~GLOB_BUTTON_ANIMATE_A~, \                -- 41
            ~GLOB_BUTTON_LOOK_FROM~, \                -- 42
            ~GLOB_BUTTON_OPTION_DISABLED~, \          -- 43
            ~GLOB_BUTTON_OTHER_TREES~, \              -- 44
            ~GLOB_BUTTON_ADD_NEW_MAT~, \              -- 45
            ~GLOB_BUTTON_RESET_MAT~, \                -- 46
            ~GLOB_BUTTON_MAT_EDITOR~, \               -- 47
            ~GLOB_BUTTON_EDIT~, \                     -- 48
            ~GLOB_BUTTON_NONE~, \                     -- 49
            ~GLOB_BUTTON_RELOAD_DXF~, \               -- 50
            ~GLOB_BUTTON_REVERT_WORLD~, \             -- 51
            ~GLOB_BUTTON_REVERT_EXTENTS~, \           -- 52
            ~GLOB_BUTTON_HIGHLIGHT_FACES~, \          -- 53
            ~GLOB_BUTTON_PLUS~, \                     -- 54
            ~GLOB_BUTTON_APPLY_COLOR~, \              -- 55
            ~GLOB_BUTTON_DISPLAY_REPORT~, \           -- 56
            ~GLOB_BUTTON_OTHER_SIGNS~, \              -- 57
            ~GLOB_BUTTON_OTHER_SIGNALS~, \            -- 58
            ~GLOB_BUTTON_FG_ON~, \                    -- 59
            ~GLOB_BUTTON_SETUP_TIME_DATE~, \          -- 60
            ~GLOB_BUTTON_ATTACH_TO_OBJECT~, \         -- 61
            ~GLOB_BUTTON_IMPORT_FILE~, \              -- 62
            ~GLOB_BUTTON_PICK_SURFACE~, \             -- 63
            ~GLOB_BUTTON_PICK_SHAPE~, \               -- 64
            ~GLOB_BUTTON_PICK_SHAPE_BY_NAME~, \       -- 65
            ~GLOB_BUTTON_RESAMPLE_SHAPE~, \           -- 66
            ~GLOB_BUTTON_CLEAR_SHAPES~, \             -- 67
            ~GLOB_BUTTON_RESTRICT_TO_MATID~, \        -- 68
            ~GLOB_BUTTON_CHANGE_MATERIAL~, \          -- 69
            ~GLOB_BUTTON_APPLY_SPLINEMAPPER~, \       -- 70
            ~GLOB_BUTTON_MODIFY_TILING~, \            -- 71
            ~GLOB_BUTTON_SELECT~, \                   -- 72
            ~GLOB_BUTTON_PICK_PARENT_SURFACE~, \      -- 73
            ~GLOB_BUTTON_ITALIC~, \                   -- 74
            ~GLOB_BUTTON_UNDERLINE~, \                -- 75
            ~GLOB_BUTTON_PICK_SOURCE_OBJECT~, \       -- 76
            ~GLOB_BUTTON_SELECT_ALL_VEHICLES~, \      -- 77
            ~GLOB_BUTTON_SELECT_NO_VEHICLES~, \       -- 78
            ~GLOB_BUTTON_PICK_TRACKING_SURFACE~, \    -- 79
            ~GLOB_BUTTON_REM_TRACKING_SURFACE~, \     -- 80
            ~GLOB_BUTTON_UPDATE_VEHICLES~, \          -- 81
            ~GLOB_BUTTON_SET_SHAPE~, \                -- 82
            ~GLOB_BUTTON_SET_SURFACE~, \              -- 83
            ~GLOB_BUTTON_SET_SPLINE~, \               -- 84
            ~GLOB_BUTTON_SET_HOFFSET~, \              -- 85
            ~GLOB_BUTTON_SET_VOFFSET~, \              -- 86
            ~GLOB_BUTTON_SET_ROTATION~, \             -- 87
            ~GLOB_BUTTON_SPACE_BY_STATION~, \         -- 88
            ~GLOB_BUTTON_SET_LOOPING~, \              -- 89
            ~GLOB_BUTTON_SET_SHAPE_TRACK~, \          -- 90
            ~GLOB_BUTTON_SET_LONGFALL_TRACK~, \       -- 91
            ~GLOB_BUTTON_SET_NORMAL_TRACK~, \         -- 92
            ~GLOB_BUTTON_STATION_OFFSET~, \           -- 93
            ~GLOB_BUTTON_SET_BOUNDING_BOX~, \         -- 94
            ~GLOB_BUTTON_BAKE_XYZ~, \                 -- 95
            ~GLOB_BUTTON_CLONE_TO_SHAPE~, \           -- 96
            ~GLOB_BUTTON_ADD_OBJECT~, \               -- 97
            ~GLOB_BUTTON_REMOVE_OBJECT~, \            -- 98
            ~GLOB_BUTTON_FILE~, \                     -- 99
            ~GLOB_BUTTON_MIRROR~, \                   -- 100
            ~GLOB_BUTTON_MULTIPLE~, \                 -- 101
            ~GLOB_BUTTON_FLIP_POST~, \                -- 102
            ~GLOB_BUTTON_CAP_TOP~, \                  -- 103
            ~GLOB_BUTTON_CAP_BASE~, \                 -- 104
            ~GLOB_BUTTON_PROFILE_FROM_SHAPE~, \       -- 105
            ~GLOB_BUTTON_IMPORT_FROM_SHAPE~, \        -- 106
            ~GLOB_BUTTON_EXPORT_INPUT_FILE~, \        -- 107
            ~GLOB_BUTTON_GROUP_NAME~, \               -- 108
            ~GLOB_BUTTON_INI_FILE~, \                 -- 109
            ~GLOB_BUTTON_SOURCE_FILE~, \              -- 110
            ~GLOB_BUTTON_PREVIEW_FILE~, \             -- 111
            ~GLOB_BUTTON_PRIMITIVE_TYPE~, \           -- 112
            ~GLOB_BUTTON_LENS_SIZE~, \                -- 113
            ~GLOB_BUTTON_DIFFUSE_MAP~, \              -- 114
            ~GLOB_BUTTON_OPACITY_MAP~, \              -- 115
            ~GLOB_BUTTON_SELECT_ALL_PIPES~, \         -- 116
            ~GLOB_BUTTON_SELECT_ALL_STRUCTURES~, \    -- 117
            ~GLOB_BUTTON_SELECT_PIPE_NETWORK~, \      -- 118
            ~GLOB_BUTTON_INSTALL_SUN_ENVIRONMENT~, \  -- 119
            ~GLOB_BUTTON_SUN_ENVIRONMENT_INSTALLED~, \-- 120
            ~GLOB_BUTTON_CREATE~ \                    -- 121
          )

          global DYNuiResourcesMenus = #( \
            ~GLOB_MENU_EXECUTE~, \                    -- 01
            ~GLOB_MENU_REFRESH~, \                    -- 02
            ~GLOB_MENU_EXPAND_ALL~, \                 -- 03
            ~GLOB_MENU_COLLAPSE_ALL~, \               -- 04
            ~GLOB_MENU_HELP~, \                       -- 05
            ~GLOB_MENU_TUTORIALS~, \                  -- 06
            ~GLOB_MENU_RENAME~, \                     -- 07
            ~GLOB_MENU_PROPERTIES~, \                 -- 08
            ~GLOB_MENU_CLONE~, \                      -- 09
            ~GLOB_MENU_DELETE~, \                     -- 10
            ~GLOB_MENU_ZOOM_SELECTED~, \              -- 11
            ~GLOB_MENU_COLLAPSE~, \                   -- 12
            ~GLOB_MENU_EXPAND~, \                     -- 13
            ~GLOB_MENU_SELECT_ALL~, \                 -- 14
            ~GLOB_MENU_SELECT_NONE~, \                -- 15
            ~GLOB_MENU_SELECT_HIGHLIGHTED~, \         -- 16
            ~GLOB_MENU_DESELECT_HIGHLIGHTED~, \       -- 17
            ~GLOB_MENU_SELECT_MATCHES~, \             -- 18
            ~GLOB_MENU_DESELECT_MATCHES~, \           -- 19
            ~GLOB_MENU_BY_NAME~, \                    -- 20
            ~GLOB_MENU_BY_TYPE~, \                    -- 21
            ~GLOB_MENU_BY_SITE~, \                    -- 22
            ~GLOB_MENU_BY_ASSEMBLY~, \                -- 23
            ~GLOB_MENU_BY_LAYER~, \                   -- 24
            ~GLOB_MENU_SELECT_MODEL~, \               -- 25
            ~GLOB_MENU_DESELECT_MODEL~, \             -- 26
            ~GLOB_MENU_SELECT_ALL_MODELS~, \          -- 27
            ~GLOB_MENU_DESELECT_ALL_MODEL~, \         -- 28
            ~GLOB_MENU_BY_STRING_TYPE~, \             -- 29
            ~GLOB_MENU_BY_SUB_REFERENCE~, \           -- 30
            ~GLOB_MENU_BY_STRING_LABEL~, \            -- 31
            ~GLOB_MENU_INSERT_ELEMENT~, \             -- 32
            ~GLOB_MENU_CUT~, \                        -- 33
            ~GLOB_MENU_COPY~, \                       -- 34
            ~GLOB_MENU_PASTE~, \                      -- 35
            ~GLOB_MENU_MODIFY_MATID~, \               -- 36
            ~GLOB_MENU_MODIFY_TILING~, \              -- 37
            ~GLOB_MENU_MODIFY_SMOOTHING~, \           -- 38
            ~GLOB_MENU_CALCULATE_AREA~, \             -- 39
            ~GLOB_MENU_DELETE_FACES~, \               -- 40
            ~GLOB_MENU_LARGE_ICONS~, \                -- 41
            ~GLOB_MENU_SMALL_ICONS~, \                -- 42
            ~GLOB_MENU_LIST~, \                       -- 43
            ~GLOB_MENU_DETAILS~, \                    -- 44
            ~GLOB_MENU_OPEN~, \                       -- 45
            ~GLOB_MENU_EDIT~, \                       -- 46
            ~GLOB_MENU_COUNTRY_KIT~, \                -- 47
            ~GLOB_MENU_PROJECT_KIT~, \                -- 48
            ~GLOB_MENU_PRIVATE_KIT~, \                -- 49
            ~GLOB_MENU_IMPORTMAN~, \                  -- 50
            ~GLOB_MENU_BAKE_XYZ~, \                   -- 51
            ~GLOB_MENU_DISPLAY_REPORT~, \             -- 52
            ~GLOB_MENU_MARKING_OBJECT~, \             -- 53
            ~GLOB_MENU_CHEVRON_OBJECT~, \             -- 54
            ~GLOB_MENU_RAIL_OBJECT~, \                -- 55
            ~GLOB_MENU_SWEPT_OBJECT~, \               -- 56
            ~GLOB_MENU_BUILDING_OBJECT~, \            -- 57
            ~GLOB_MENU_FOREST_OBJECT~, \              -- 58
            ~GLOB_MENU_MESH_OBJECT~, \                -- 59
            ~GLOB_MENU_APPLY_OPS~, \                  -- 60
            ~GLOB_MENU_LOOK_FROM_CAM~, \              -- 61
            ~GLOB_MENU_COLLAPSE_TO_MESH~, \           -- 62
            ~GLOB_MENU_HIDDEN~, \                     -- 63
            ~GLOB_MENU_FROZEN~, \                     -- 64
            ~GLOB_MENU_PLACEDMAN_01~, \               -- 65
            ~GLOB_MENU_PLACEDMAN_02~, \               -- 66
            ~GLOB_MENU_PLACEDMAN_03~, \               -- 67
            ~GLOB_MENU_PLACEDMAN_04~, \               -- 68
            ~GLOB_MENU_PLACEDMAN_05~, \               -- 69
            ~GLOB_MENU_PLACEDMAN_06~, \               -- 70
            ~GLOB_MENU_PLACEDMAN_07~, \               -- 71
            ~GLOB_MENU_PLACEDMAN_08~, \               -- 72
            ~GLOB_MENU_PLACEDMAN_09~, \               -- 73
            ~GLOB_MENU_PLACEDMAN_10~, \               -- 74
            ~GLOB_MENU_PLACEDMAN_11~, \               -- 75
            ~GLOB_MENU_PLACEDMAN_12~, \               -- 76
            ~GLOB_MENU_PLACEDMAN_13~, \               -- 77
            ~GLOB_MENU_PLACEDMAN_14~, \               -- 78
            ~GLOB_MENU_PLACEDMAN_15~, \               -- 79
            ~GLOB_MENU_PLACEDMAN_16~, \               -- 80
            ~GLOB_MENU_CV_EXPLORER_01~, \             -- 81
            ~GLOB_MENU_CV_EXPLORER_29~, \             -- 82
            ~GLOB_MENU_CV_EXPLORER_03~, \             -- 83
            ~GLOB_MENU_CV_EXPLORER_04~, \             -- 84
            ~GLOB_MENU_CV_EXPLORER_05~, \             -- 85
            ~GLOB_MENU_CV_EXPLORER_28~, \             -- 86
            ~GLOB_MENU_CV_EXPLORER_07~, \             -- 87
            ~GLOB_MENU_CV_EXPLORER_08~, \             -- 88
            ~GLOB_MENU_CV_EXPLORER_09~, \             -- 89
            ~GLOB_MENU_CV_EXPLORER_10~, \             -- 90
            ~GLOB_MENU_CV_EXPLORER_11~, \             -- 91
            ~GLOB_MENU_CV_EXPLORER_12~, \             -- 92
            ~GLOB_MENU_CV_EXPLORER_13~, \             -- 93
            ~GLOB_MENU_CV_EXPLORER_14~, \             -- 94
            ~GLOB_MENU_CV_EXPLORER_15~, \             -- 95
            ~GLOB_MENU_CV_EXPLORER_16~, \             -- 96
            ~GLOB_MENU_CV_EXPLORER_17~, \             -- 97
            ~GLOB_MENU_CV_EXPLORER_18~, \             -- 98
            ~GLOB_MENU_CV_EXPLORER_19~, \             -- 99
            ~GLOB_MENU_CV_EXPLORER_20~, \             -- 100
            ~GLOB_MENU_CV_EXPLORER_21~, \             -- 101
            ~GLOB_MENU_CV_EXPLORER_22~, \             -- 102
            ~GLOB_MENU_CV_EXPLORER_23~, \             -- 103
            ~GLOB_MENU_CV_EXPLORER_24~, \             -- 104
            ~GLOB_MENU_CV_EXPLORER_25~, \             -- 105
            ~GLOB_MENU_CV_EXPLORER_26~, \             -- 106
            ~GLOB_MENU_UPDATE_SELECTED~, \            -- 107
            ~GLOB_MENU_CHANGE_SOURCE_FILE~, \         -- 108
            ~GLOB_MENU_CHANGE_SOURCE_OBJECT~, \       -- 109
            ~GLOB_MENU_EXPORT_TO_TXT~, \              -- 110
            ~GLOB_MENU_SELECT_INVERT~, \              -- 111
            ~GLOB_MENU_SHOW_SOURCE_PATH~, \           -- 112
            ~GLOB_MENU_UNSORT~, \                     -- 113
            ~GLOB_MENU_EXPORT_TO_OPS~, \              -- 114
            ~GLOB_MENU_OPEN_STYLE~, \                 -- 115
            ~GLOB_MENU_APPLY_STYLE_TO_SHAPE~, \       -- 116
            ~GLOB_MENU_EDIT_DEFINITION~, \            -- 117
            ~GLOB_MENU_PLACE_AT_START~, \             -- 118
            ~GLOB_MENU_PLACE_AT_MID~, \               -- 119
            ~GLOB_MENU_PLACE_AT_END~, \               -- 120
            ~GLOB_MENU_MULTIPLE_AT_REGULAR~, \        -- 121
            ~GLOB_MENU_MULTIPLE_AT_RANDOM~, \         -- 122
            ~GLOB_MENU_AT_CONSTANT_SPEED~, \          -- 123
            ~GLOB_MENU_CV_EXPLORER_27~ \              -- 124
          )

          global DYNuiResourcesSubMenus = #( \
            ~GLOB_SUBMENU_FILE~, \                    -- 01
            ~GLOB_SUBMENU_EDIT~, \                    -- 02
            ~GLOB_SUBMENU_VIEW~, \                    -- 03
            ~GLOB_SUBMENU_HELP~, \                    -- 04
            ~GLOB_SUBMENU_VEHICLE_TYPE~, \            -- 05
            ~GLOB_SUBMENU_BODY_COLOR~, \              -- 06
            ~GLOB_SUBMENU_INSTANT_PLACEMENT~, \       -- 07
            ~GLOB_SUBMENU_MOVE_TO~, \                 -- 08
            ~GLOB_SUBMENU_COPY_TO~, \                 -- 09
            ~GLOB_SUBMENU_PLACE_ON_SELECTED~, \       -- 10
            ~GLOB_SUBMENU_ANIMATION_TOOLS~, \         -- 11
            ~GLOB_SUBMENU_APPLY_ANIMATION~, \         -- 12
            ~GLOB_SUBMENU_REVERSE_ANIMATION~, \       -- 13
            ~GLOB_SUBMENU_REMOVE_ANIMATION~, \        -- 14
            ~GLOB_SUBMENU_SCALE_ANIMATION~, \         -- 15
            ~GLOB_SUBMENU_BY_VEHICLE_TYPE_NAME~, \    -- 16
            ~GLOB_SUBMENU_BY_VEHICLE_TYPE_ID~, \      -- 17
            ~GLOB_SUBMENU_BY_SOURCE_ZONE~, \          -- 18
            ~GLOB_SUBMENU_BY_DESTINATION_ZONE~ \      -- 19
          )

          global DYNuiResourcesGroups = #( \
            ~GLOB_GRPS_PARAM_INSTANCING~, \           -- 01
            ~GLOB_GRPS_SELECTION_OPTIONS~, \          -- 02
            ~GLOB_GRPS_GENERAL_PARAMS~, \             -- 03
            ~GLOB_GRPS_FOG_COLOR~, \                  -- 04
            ~GLOB_GRPS_FILE_DETAILS~, \               -- 05
            ~GLOB_GRPS_OBJECT_PROPERTIES~, \          -- 06
            ~GLOB_GRPS_SOURCE_FILE~, \                -- 07
            ~GLOB_GRPS_PRIMARY_MATID~, \              -- 08
            ~GLOB_GRPS_EDIT_STYLE_ELEMENT~, \         -- 09
            ~GLOB_GRPS_CLOSING_SURFACE~, \            -- 10
            ~GLOB_GRPS_SPANNING_SURFACE~, \           -- 11
            ~GLOB_GRPS_CAPPING_SURFACE~, \            -- 12
            ~GLOB_GRPS_UV_MAPPING~, \                 -- 13
            ~GLOB_GRPS_PARENT_SHAPE~, \               -- 14
            ~GLOB_GRPS_SOS_STYLES~, \                 -- 15
            ~GLOB_GRPS_MATERIAL~, \                   -- 16
            ~GLOB_GRPS_EDIT_PROFILE_ELEMENT~, \       -- 17
            ~GLOB_GRPS_PARENT_OBJECT~, \              -- 18
            ~GLOB_GRPS_RELATIVE_POSITION~, \          -- 19
            ~GLOB_GRPS_VEHICLE_TYPE~, \               -- 20
            ~GLOB_GRPS_BODY_COLOR~, \                 -- 21
            ~GLOB_GRPS_OTHER_PARAMS~, \               -- 22
            ~GLOB_GRPS_IMPORT_SHIFT~, \               -- 23
            ~GLOB_GRPS_MARKING_SETTINGS~, \           -- 24
            ~GLOB_GRPS_MAT_LIBRARY~, \                -- 25
            ~GLOB_GRPS_PROJ_RESKIT_STATUS~, \         -- 26
            ~GLOB_GRPS_OBJECT_LINKING~, \             -- 27
            ~GLOB_GRPS_TREE_STYLE~, \                 -- 28
            ~GLOB_GRPS_TREE_DIMS~, \                  -- 29
            ~GLOB_GRPS_VEHICLE_MAT_PARAMS~, \         -- 30
            ~GLOB_GRPS_MARKING_MAT_PARAMS~, \         -- 31
            ~GLOB_GRPS_AMBIENT_LIGHT~, \              -- 32
            ~GLOB_GRPS_SOURCE_INFO~, \                -- 33
            ~GLOB_GRPS_DATE_IMPORTED~, \              -- 34
            ~GLOB_GRPS_PARTICLE_SYS_PARAMS~, \        -- 35
            ~GLOB_GRPS_DISPLAY_OPTIONS~, \            -- 36
            ~GLOB_GRPS_CURRENT_OBJECT~, \             -- 37
            ~GLOB_GRPS_SHADOW_PARAMS~, \              -- 38
            ~GLOB_GRPS_SKYLIGHT_PARAMS~, \            -- 39
            ~GLOB_GRPS_IES_PARAMS~, \                 -- 40
            ~GLOB_GRPS_BUILDING_HEIGHT~, \            -- 41
            ~GLOB_GRPS_WALL_MAPPING~, \               -- 42
            ~GLOB_GRPS_BOS_STYLES~, \                 -- 43
            ~GLOB_GRPS_MATERIAL_TILING~, \            -- 44
            ~GLOB_GRPS_SURFACE_PARAMS~, \             -- 45
            ~GLOB_GRPS_BITMAP~, \                     -- 46
            ~GLOB_GRPS_PLACEMENT_COORDS~, \           -- 47
            ~GLOB_GRPS_MARKING_DIMS~, \               -- 48
            ~GLOB_GRPS_MARKING_COLOR~, \              -- 49
            ~GLOB_GRPS_SHIFT_OFFSET~, \               -- 50
            ~GLOB_GRPS_OPTIMIZATION~, \               -- 51
            ~GLOB_GRPS_PRIMITIVE_MATID~, \            -- 52
            ~GLOB_GRPS_PRIMITIVE_DIMS~, \             -- 53
            ~GLOB_GRPS_PRIMITIVE_COMPLEXITY~, \       -- 54
            ~GLOB_GRPS_SHAPE_PARAMS~, \               -- 55
            ~GLOB_GRPS_SPLINE_PARAMS~, \              -- 56
            ~GLOB_GRPS_SIGN_FACE~, \                  -- 57
            ~GLOB_GRPS_SIGN_FACE_DIMS~, \             -- 58
            ~GLOB_GRPS_POST_DIMS~, \                  -- 59
            ~GLOB_GRPS_SIGNAL_FACE~, \                -- 60
            ~GLOB_GRPS_SIGNAL_PHASING~, \             -- 61
            ~GLOB_GRPS_SIGNAL_FACE_DIMS~, \           -- 62
            ~GLOB_GRPS_ALIGNMENT_PARAMS~, \           -- 63
            ~GLOB_GRPS_SPEED_TABLE~, \                -- 64
            ~GLOB_GRPS_TINT_PARAMS~, \                -- 65
            ~GLOB_GRPS_LIGHT_INSTANCING~, \           -- 66
            ~GLOB_GRPS_SUN_POSITIONER_COMPASS~, \     -- 67
            ~GLOB_GRPS_LIGHT_CONE_PARAMS~, \          -- 68
            ~GLOB_GRPS_POST_MATERIAL~, \              -- 69
            ~GLOB_GRPS_ARM_PARAMS~, \                 -- 70
            ~GLOB_GRPS_LAMP_PARAMS~, \                -- 71
            ~GLOB_GRPS_GANTRY_MATERIAL~, \            -- 72
            ~GLOB_GRPS_GANTRY_STYLE~, \               -- 73
            ~GLOB_GRPS_GANTRY_DIMS~, \                -- 74
            ~GLOB_GRPS_ADDITIONAL_DIMS~, \            -- 75
            ~GLOB_GRPS_SIGNAL_PARAMS~, \              -- 76
            ~GLOB_GRPS_USE_PRESET~, \                 -- 77
            ~GLOB_GRPS_FG_SETTINGS~, \                -- 78
            ~GLOB_GRPS_GLOBAL~, \                     -- 79
            ~GLOB_GRPS_SUN~, \                        -- 80
            ~GLOB_GRPS_HORIZON_GROUND~, \             -- 81
            ~GLOB_GRPS_SKY~, \                        -- 82
            ~GLOB_GRPS_SUN_POSITIONER_SUN~, \         -- 83
            ~GLOB_GRPS_PHOTONS~, \                    -- 84
            ~GLOB_GRPS_HORIZON_PARAMS~, \             -- 85
            ~GLOB_GRPS_NIGHT_PARAMS~, \               -- 86
            ~GLOB_GRPS_NON_PHYSICAL_TUNING~, \        -- 87
            ~GLOB_GRPS_PARENT_SURFACE~, \             -- 88
            ~GLOB_GRPS_STATION_CONTROL~, \            -- 89
            ~GLOB_GRPS_PHYSICAL_SCALE~, \             -- 90
            ~GLOB_GRPS_EXPOSURE~, \                   -- 91
            ~GLOB_GRPS_IMAGE_CONTROL~, \              -- 92
            ~GLOB_GRPS_DISPLAY_RANAGE~, \             -- 93
            ~GLOB_GRPS_FEATURE_INTERPRETATION~, \     -- 94
            ~GLOB_GRPS_SPLINEMAPPER_2~, \             -- 95
            ~GLOB_GRPS_SPLINEMAPPER_3~, \             -- 96
            ~GLOB_GRPS_SPLINEMAPPER_4~, \             -- 97
            ~GLOB_GRPS_DRAPE_STYLE~, \                -- 98
            ~GLOB_GRPS_DRAPE_SHAPES~, \               -- 99
            ~GLOB_GRPS_SELECT_LEVEL~, \               -- 100
            ~GLOB_GRPS_PARENT_OBJECTS~, \             -- 101
            ~GLOB_GRPS_PLACEMENT_PARAMS~, \           -- 102
            ~GLOB_GRPS_FONT_STYLE~, \                 -- 103
            ~GLOB_GRPS_RENDERING_PARAMS~, \           -- 104
            ~GLOB_GRPS_CLONE_TYPE~, \                 -- 105
            ~GLOB_GRPS_CLONE_PARAMS~, \               -- 106
            ~GLOB_GRPS_VEHICLE_BEARING~, \            -- 107
            ~GLOB_GRPS_SELECT_BY_TYPE~, \             -- 108
            ~GLOB_GRPS_SCENE_ANIMATION~, \            -- 109
            ~GLOB_GRPS_TIME_FILTER~, \                -- 110
            ~GLOB_GRPS_STEP_FILTER~, \                -- 111
            ~GLOB_GRPS_GLOBAL_SHIFT~, \               -- 112
            ~GLOB_GRPS_EDIT_OBJECTS~, \               -- 113
            ~GLOB_GRPS_SIGHT_OUTPUT~, \               -- 114
            ~GLOB_GRPS_SIGHT_ANALYSIS~, \             -- 115
            ~GLOB_GRPS_ROS_ELEMENT~, \                -- 116
            ~GLOB_GRPS_SOS_ELEMENT~, \                -- 117
            ~GLOB_GRPS_RMS_ELEMENT~, \                -- 118
            ~GLOB_GRPS_BOS_ELEMENT~, \                -- 119
            ~GLOB_GRPS_OPS_ELEMENT~, \                -- 120
            ~GLOB_GRPS_FIS_ELEMENT~, \                -- 121
            ~GLOB_GRPS_SHAPE_LABEL_MASK~, \           -- 122
            ~GLOB_GRPS_POST_PAPRAMS~, \               -- 123
            ~GLOB_GRPS_BRACE_PARAMS~, \               -- 124
            ~GLOB_GRPS_RAIL_PARAMS~, \                -- 125
            ~GLOB_GRPS_SPLINE_RENDERING~, \           -- 126
            ~GLOB_GRPS_CLOSED_SHAPE_TO_SURFACE~, \    -- 127
            ~GLOB_GRPS_LONG_COMPLEXITY~, \            -- 128
            ~GLOB_GRPS_PROFILE_DIRECTION~, \          -- 129
            ~GLOB_GRPS_ELEMENT_PARAMS~, \             -- 130
            ~GLOB_GRPS_MAT_ASSIGNMENT~, \             -- 131
            ~GLOB_GRPS_IMPORT_EXPORT_PROFILE~, \      -- 132
            ~GLOB_GRPS_SEGMENT_INTERPOLATION~, \      -- 133
            ~GLOB_GRPS_PREVIEW~, \                    -- 134
            ~GLOB_GRPS_PRIMITIVE_TYPE~, \             -- 135
            ~GLOB_GRPS_LENS_SIZE~, \                  -- 136
            ~GLOB_GRPS_DIFFUSE_MAP~, \                -- 137
            ~GLOB_GRPS_OPACITY_MAP~, \                -- 138
            ~GLOB_GRPS_INI_FILE_SETTINGS~, \          -- 139
            ~GLOB_GRPS_OTHER_OPTIONS~, \              -- 140
            ~GLOB_GRPS_LONG_PLACEMENT~, \             -- 141
            ~GLOB_GRPS_LATERAL_PLACEMENT~, \          -- 142
            ~GLOB_GRPS_ANIMATION_OPTIONS~, \          -- 143
            ~GLOB_GRPS_ADVANCED_LIGHTING~, \          -- 144
            ~GLOB_GRPS_STRUCTURE_DIMENSIONS~, \       -- 145
            ~GLOB_GRPS_FRAME_DIMENSIONS~, \           -- 146
            ~GLOB_GRPS_CONE_DIMENSIONS~, \            -- 147
            ~GLOB_GRPS_PIPE_DIMENSIONS~, \            -- 148
            ~GLOB_GRPS_EXPOSURE_PC~, \                -- 149
            ~GLOB_LABEL_EXPOSURE_PC_GLOBAL~, \        -- 150
            ~GLOB_GRPS_ILLUMINANCE_MODEL~, \          -- 151
            ~GLOB_GRPS_COLOR_TUNING~, \               -- 152
            ~GLOB_GRPS_SUN_WIDGET~ \                  -- 153
          )

          global DYNuiResourcesLabels = #( \
            ~GLOB_LABEL_HOR_OFFSET~, \                -- 01
            ~GLOB_LABEL_VER_OFFSET~, \                -- 02
            ~GLOB_LABEL_START_HOR_OFFSET~, \          -- 03
            ~GLOB_LABEL_END_HOR_OFFSET~, \            -- 04
            ~GLOB_LABEL_START_VER_OFFSET~, \          -- 05
            ~GLOB_LABEL_END_VER_OFFSET~, \            -- 06
            ~GLOB_LABEL_START_CROSSFALL~, \           -- 07
            ~GLOB_LABEL_END_CROSSFALL~, \             -- 08
            ~GLOB_LABEL_START_STATION~, \             -- 09
            ~GLOB_LABEL_END_STATION~, \               -- 10
            ~GLOB_LABEL_CROSSFALL~, \                 -- 11
            ~GLOB_LABEL_ROTATION~, \                  -- 12
            ~GLOB_LABEL_INTERVAL~, \                  -- 13
            ~GLOB_LABEL_NAME~, \                      -- 14
            ~GLOB_LABEL_CATEGORY~, \                  -- 15
            ~GLOB_LABEL_BOTH~, \                      -- 16
            ~GLOB_LABEL_LEFT~, \                      -- 17
            ~GLOB_LABEL_RIGHT~, \                     -- 18
            ~GLOB_LABEL_TOTAL~, \                     -- 19
            ~GLOB_LABEL_CAST_SHADOWS~, \              -- 20
            ~GLOB_LABEL_BOUNDING_BOX~, \              -- 21
            ~GLOB_LABEL_ON~, \                        -- 22
            ~GLOB_LABEL_NEAR~, \                      -- 23
            ~GLOB_LABEL_FAR~, \                       -- 24
            ~GLOB_LABEL_PLACE_SINGLE_OBJECT~, \       -- 25
            ~GLOB_LABEL_PLACE_MULTIPLE_INTERVAL~, \   -- 26
            ~GLOB_LABEL_PLACE_MULTIPLE_STATION~, \    -- 27
            ~GLOB_LABEL_LENGTH~, \                    -- 28
            ~GLOB_LABEL_WIDTH~, \                     -- 29
            ~GLOB_LABEL_HEIGHT~, \                    -- 30
            ~GLOB_LABEL_COUNT~, \                     -- 31
            ~GLOB_LABEL_FILE_CREATION_DATE~, \        -- 32
            ~GLOB_LABEL_FILE_MODIFIED_DATE~, \        -- 33
            ~GLOB_LABEL_DXF_FOLDER~, \                -- 34
            ~GLOB_LABEL_TINT_HEIGHT~, \               -- 35
            ~GLOB_LABEL_TINT_NOISE_SIZE~, \           -- 36
            ~GLOB_LABEL_TINT_NOISE_PHASE~, \          -- 37
            ~GLOB_LABEL_TINT_NOISE_AMOUNT~, \         -- 38
            ~GLOB_LABEL_SKY_INTENSITY~, \             -- 39
            ~GLOB_LABEL_DATE_IMPORTED~, \             -- 40
            ~GLOB_LABEL_DATE_CREATED~, \              -- 41
            ~GLOB_LABEL_DISPLAY_AS_BOX~, \            -- 42
            ~GLOB_LABEL_FROZEN~, \                    -- 43
            ~GLOB_LABEL_HIDDEN~, \                    -- 44
            ~GLOB_LABEL_OBJECT_CATEGORY~, \           -- 45
            ~GLOB_LABEL_PARENT_SHAPE~, \              -- 46
            ~GLOB_LABEL_PARENT_SURFACE~, \            -- 47
            ~GLOB_LABEL_NO_CV_OBJECTS~, \             -- 48
            ~GLOB_LABEL_MULTIPLE_CV_OBJECTS~, \       -- 49
            ~GLOB_LABEL_SRC_FEATURE_NAME~, \          -- 50
            ~GLOB_LABEL_SRC_PARENT_NAME~, \           -- 51
            ~GLOB_LABEL_MULT_SOURCES_SELECTED~, \     -- 52
            ~GLOB_LABEL_SHAPE_LABEL_MASK~, \          -- 53
            ~GLOB_LABEL_MARK_LENGTH~, \               -- 54
            ~GLOB_LABEL_GAP_LENGTH~, \                -- 55
            ~GLOB_LABEL_COLOR~, \                     -- 56
            ~GLOB_LABEL_SELECT_TREE~, \               -- 57
            ~GLOB_LABEL_LENGTH_REPEAT~, \             -- 58
            ~GLOB_LABEL_WIDTH_TILING~, \              -- 59
            ~GLOB_LABEL_MAP_ROTATION~, \              -- 60
            ~GLOB_LABEL_SKEW~, \                      -- 61
            ~GLOB_LABEL_FLIP_SURFACE~, \              -- 62
            ~GLOB_LABEL_SMOOTH_GROUP~, \              -- 63
            ~GLOB_LABEL_INHERITED~, \                 -- 64
            ~GLOB_LABEL_GAP~, \                       -- 65
            ~GLOB_LABEL_INVERT_H_OFFSET~, \           -- 66
            ~GLOB_LABEL_OVERRIDES_MAPPING~, \         -- 67
            ~GLOB_LABEL_USE_INHERITED_MAT~, \         -- 68
            ~GLOB_LABEL_SEPARATED_GEOMETRY~, \        -- 69
            ~GLOB_LABEL_SPANNING_GEOMETRY~, \         -- 70
            ~GLOB_LABEL_SEGMENT_COUNT~, \             -- 71
            ~GLOB_LABEL_SEGMENT_LENGTH~, \            -- 72
            ~GLOB_LABEL_NUMBER_OF_SEGMENTS~, \        -- 73
            ~GLOB_LABEL_BY_SEGMENT_LENGTH~, \         -- 74
            ~GLOB_LABEL_FLIP_CLOSING~, \              -- 75
            ~GLOB_LABEL_FLIP_SPANNING~, \             -- 76
            ~GLOB_LABEL_FLIP_CAPPING~, \              -- 77
            ~GLOB_LABEL_STATION_OFFSET~, \            -- 78
            ~GLOB_LABEL_ROTATION_OFFSET~, \           -- 79
            ~GLOB_LABEL_TARGET_DISTANCE~, \           -- 80
            ~GLOB_LABEL_FOG_NEAR~, \                  -- 81
            ~GLOB_LABEL_FOG_FAR~, \                   -- 82
            ~GLOB_LABEL_VERTICAL_TILT~, \             -- 83
            ~GLOB_LABEL_LENS_SIZE~, \                 -- 84
            ~GLOB_LABEL_VEHICLE_TYPES~, \             -- 85
            ~GLOB_LABEL_NON_CIVIL_VIEW~, \            -- 86
            ~GLOB_LABEL_FREEZE_MARKINGS~, \           -- 87
            ~GLOB_LABEL_FULL~, \                      -- 88
            ~GLOB_LABEL_OPTIMIZED~, \                 -- 89
            ~GLOB_LABEL_X_SHIFT~, \                   -- 90
            ~GLOB_LABEL_Y_SHIFT~, \                   -- 91
            ~GLOB_LABEL_VERT_SHIFT~, \                -- 92
            ~GLOB_LABEL_TREE_HEIGHT~, \               -- 93
            ~GLOB_LABEL_TREE_WIDTH~, \                -- 94
            ~GLOB_LABEL_PLANES_COUNT~, \              -- 95
            ~GLOB_LABEL_SUBMAT_LIST~, \               -- 96
            ~GLOB_LABEL_SUBMAT_PREVIEW~, \            -- 97
            ~GLOB_LABEL_BODY_REFLECTIONS~, \          -- 98
            ~GLOB_LABEL_AMOUNT~, \                    -- 99
            ~GLOB_LABEL_MAP_QUALITY~, \               -- 100
            ~GLOB_LABEL_MAP_BLUR~, \                  -- 101
            ~GLOB_LABEL_NO_ADV_LIGHTING~, \           -- 102
            ~GLOB_LABEL_LIGHT_TRACER~, \              -- 103
            ~GLOB_LABEL_RADIOSITY~, \                 -- 104
            ~GLOB_LABEL_AMBIENT_LIGHT~, \             -- 105
            ~GLOB_LABEL_LIGHTS~, \                    -- 106
            ~GLOB_LABEL_NEW_OBJECT_NAME~, \           -- 107
            ~GLOB_LABEL_ENABLE_POINTS~, \             -- 108
            ~GLOB_LABEL_SHOW_POINT_IDS~, \            -- 109
            ~GLOB_LABEL_USE_GEOMETRY~, \              -- 110
            ~GLOB_LABEL_DISPLAY_IN_VP~, \             -- 111
            ~GLOB_LABEL_SOURCE_INFO~, \               -- 112
            ~GLOB_LABEL_DISPLAY_IN_RENDER~, \         -- 113
            ~GLOB_LABEL_COUNTRY~, \                   -- 114
            ~GLOB_LABEL_PROJECT~, \                   -- 115
            ~GLOB_LABEL_PRIVATE~, \                   -- 116
            ~GLOB_LABEL_SOURCE~, \                    -- 117
            ~GLOB_LABEL_OPTIONS~, \                   -- 118
            ~GLOB_LABEL_GEOMETRY~, \                  -- 119
            ~GLOB_LABEL_UNDEFINED~, \                 -- 120
            ~GLOB_LABEL_NOT_APPLICABLE~, \            -- 121
            ~GLOB_LABEL_TOTAL_POINTS~, \              -- 122
            ~GLOB_LABEL_DATA_SOURCE~, \               -- 123
            ~GLOB_LABEL_OTHER_OPTIONS~, \             -- 124
            ~GLOB_LABEL_GEOMETRY_OPTIONS~, \          -- 125
            ~GLOB_LABEL_SKY_CLEAR~, \                 -- 126
            ~GLOB_LABEL_SKY_PARTLY_CLOUDY~, \         -- 127
            ~GLOB_LABEL_SKY_CLOUDY~, \                -- 128
            ~GLOB_LABEL_USE_ENVIRONMENT~, \           -- 129
            ~GLOB_LABEL_SKY_COLOR~, \                 -- 130
            ~GLOB_LABEL_MULTIPLIER~, \                -- 131
            ~GLOB_LABEL_MAP~, \                       -- 132
            ~GLOB_LABEL_RAY_BIAS~, \                  -- 133
            ~GLOB_LABEL_PER_SAMPLE~, \                -- 134
            ~GLOB_LABEL_SKY_COLOR2~, \                -- 135
            ~GLOB_LABEL_SKY_COVERAGE~, \              -- 136
            ~GLOB_LABEL_SKYLIGHT~, \                  -- 137
            ~GLOB_LABEL_IES_SKY~, \                   -- 138
            ~GLOB_LABEL_BUILDING_HEIGHT~, \           -- 139
            ~GLOB_LABEL_FLOOR_COUNT~, \               -- 140
            ~GLOB_LABEL_FLOOR_HEIGHT~, \              -- 141
            ~GLOB_LABEL_MAP_WIDTH~, \                 -- 142
            ~GLOB_LABEL_BOX_MAPPING1~, \              -- 143
            ~GLOB_LABEL_BOX_MAPPING2~, \              -- 144
            ~GLOB_LABEL_FACE_MAPPING~, \              -- 145
            ~GLOB_LABEL_WRAP_MAPPING~, \              -- 146
            ~GLOB_LABEL_WALL_MATID~, \                -- 147
            ~GLOB_LABEL_WALL_MAP_STYLE~, \            -- 148
            ~GLOB_LABEL_YES~, \                       -- 149
            ~GLOB_LABEL_NO~, \                        -- 150
            ~GLOB_LABEL_WALL_USE_INSTANCING~, \       -- 151
            ~GLOB_LABEL_BITMAP~, \                    -- 152
            ~GLOB_LABEL_VERTEX_COUNT~, \              -- 153
            ~GLOB_LABEL_FACE_COUNT~, \                -- 154
            ~GLOB_LABEL_AREA~, \                      -- 155
            ~GLOB_LABEL_DXF_LINKED_GEOM~, \           -- 156
            ~GLOB_LABEL_FACE_SETS~, \                 -- 157
            ~GLOB_LABEL_BY_MATID~, \                  -- 158
            ~GLOB_LABEL_BY_LINKCODE~, \               -- 159
            ~GLOB_LABEL_BY_SUBASM_NAME~, \            -- 160
            ~GLOB_LABEL_BY_SUBASM_CLASS~, \           -- 161
            ~GLOB_LABEL_SELECT_NEW_MATID~, \          -- 162
            ~GLOB_LABEL_SMOOTHING_THRESHOLD~, \       -- 163
            ~GLOB_LABEL_SURFACE_AREA~, \              -- 164
            ~GLOB_LABEL_TILE_SCALE~, \                -- 165
            ~GLOB_LABEL_TILE_SIZE~, \                 -- 166
            ~GLOB_LABEL_GENERAL_PARAMS~, \            -- 167
            ~GLOB_LABEL_TARGET_CHANNEL~, \            -- 168
            ~GLOB_LABEL_WIDTH_X~, \                   -- 169
            ~GLOB_LABEL_HEIGHT_Y~, \                  -- 170
            ~GLOB_LABEL_BOTTOM_LEFT_X~, \             -- 171
            ~GLOB_LABEL_BOTTOM_LEFT_Y~, \             -- 172
            ~GLOB_LABEL_TOP_RIGHT_X~, \               -- 173
            ~GLOB_LABEL_TOP_RIGHT_Y~, \               -- 174
            ~GLOB_LABEL_STATISTICS~, \                -- 175
            ~GLOB_LABEL_DRAPING~, \                   -- 176
            ~GLOB_LABEL_TILE_ROTATION~, \             -- 177
            ~GLOB_LABEL_USE_GLOBAL_SHIFT~, \          -- 178
            ~GLOB_LABEL_CHEVRON_ANGLE~, \             -- 179
            ~GLOB_LABEL_CENTRE_GAP~, \                -- 180
            ~GLOB_LABEL_HORIZ_SHIFT~, \               -- 181
            ~GLOB_LABEL_SPACING~, \                   -- 182
            ~GLOB_LABEL_THRESHOLD~, \                 -- 183
            ~GLOB_LABEL_MAX_DISTANCE~, \              -- 184
            ~GLOB_LABEL_DEPTH~, \                     -- 185
            ~GLOB_LABEL_RADIUS~, \                    -- 186
            ~GLOB_LABEL_SEGMENTS~, \                  -- 187
            ~GLOB_LABEL_HEIGHT_SEGS~, \               -- 188
            ~GLOB_LABEL_WIDTH_SEGS~, \                -- 189
            ~GLOB_LABEL_LENGTH_SEGS~, \               -- 190
            ~GLOB_LABEL_DEPTH_SEGS~, \                -- 191
            ~GLOB_LABEL_SPLINE~, \                    -- 192
            ~GLOB_LABEL_LINKED_SHAPE~, \              -- 193
            ~GLOB_LABEL_TOTAL_LENGTH~, \              -- 194
            ~GLOB_LABEL_POINT~, \                     -- 195
            ~GLOB_LABEL_SPLINE_COUNT~, \              -- 196
            ~GLOB_LABEL_INFINITY~, \                  -- 197
            ~GLOB_LABEL_PHASE_COUNT~, \               -- 198
            ~GLOB_LABEL_CURRENT_PHASE~, \             -- 199
            ~GLOB_LABEL_POST_HEIGHT~, \               -- 200
            ~GLOB_LABEL_GROUND_DEPTH~, \              -- 201
            ~GLOB_LABEL_POST_COUNT~, \                -- 202
            ~GLOB_LABEL_EDGE_OFFSET~, \               -- 203
            ~GLOB_LABEL_NONE~, \                      -- 204
            ~GLOB_LABEL_ACTUAL_LENGTH~, \             -- 205
            ~GLOB_LABEL_SELECTED_PROFILE~, \          -- 206
            ~GLOB_LABEL_RENDERED_PREVIEW~, \          -- 207
            ~GLOB_LABEL_SKY_TEXTURE~, \               -- 208
            ~GLOB_LABEL_LIGHT_TYPE~, \                -- 209
            ~GLOB_LABEL_IES_SUN~, \                   -- 210
            ~GLOB_LABEL_MAP_SIZE~, \                  -- 211
            ~GLOB_LABEL_BIAS~, \                      -- 212
            ~GLOB_LABEL_MAX_QUADTREE~, \              -- 213
            ~GLOB_LABEL_LIGHT_COLOR~, \               -- 214
            ~GLOB_LABEL_ASPECT~, \                    -- 215
            ~GLOB_LABEL_FALLOFF~, \                   -- 216
            ~GLOB_LABEL_HOTSPOT~, \                   -- 217
            ~GLOB_LABEL_SHADOW_DENSITY~, \            -- 218
            ~GLOB_LABEL_SAMPLE_RANGE~, \              -- 219
            ~GLOB_LABEL_SHOW_CONE~, \                 -- 220
            ~GLOB_LABEL_OVERSHOOT~, \                 -- 221
            ~GLOB_LABEL_ABSOLUTE_BIAS~, \             -- 222
            ~GLOB_LABEL_SHADOW_MAP~, \                -- 223
            ~GLOB_LABEL_RAY_TRACED~, \                -- 224
            ~GLOB_LABEL_CIRCULAR_LIGHT~, \            -- 225
            ~GLOB_LABEL_RECTANGULAR_LIGHT~, \         -- 226
            ~GLOB_LABEL_UPPER_DIAMETER~, \            -- 227
            ~GLOB_LABEL_LOWER_DIAMETER~, \            -- 228
            ~GLOB_LABEL_TAPER_BASE~, \                -- 229
            ~GLOB_LABEL_TAPER_LENGTH~, \              -- 230
            ~GLOB_LABEL_LEFT_ARM~, \                  -- 231
            ~GLOB_LABEL_RIGHT_ARM~, \                 -- 232
            ~GLOB_LABEL_BEND_RADIUS~, \               -- 233
            ~GLOB_LABEL_BEND_ANGLE~, \                -- 234
            ~GLOB_LABEL_ARM_LENGTH~, \                -- 235
            ~GLOB_LABEL_LAMP_SIZE~, \                 -- 236
            ~GLOB_LABEL_GANTRY_TYPE1~, \              -- 237
            ~GLOB_LABEL_GANTRY_TYPE2~, \              -- 238
            ~GLOB_LABEL_GANTRY_TYPE3~, \              -- 239
            ~GLOB_LABEL_FLIP~, \                      -- 240
            ~GLOB_LABEL_RESTRICT_POST~, \             -- 241
            ~GLOB_LABEL_TUBE_DIAMETER~, \             -- 242
            ~GLOB_LABEL_SIGNAL_COUNT~, \              -- 243
            ~GLOB_LABEL_SIGNAL_SPACING~, \            -- 244
            ~GLOB_LABEL_SIGNAL_OFFSET~, \             -- 245
            ~GLOB_LABEL_CUSTOM~, \                    -- 246
            ~GLOB_LABEL_POINT_DENSITY~, \             -- 247
            ~GLOB_LABEL_RAYS_PER_POINT~, \            -- 248
            ~GLOB_LABEL_INTERP_OVER_PTS~, \           -- 249
            ~GLOB_LABEL_DIFFUSE_BOUNCES~, \           -- 250
            ~GLOB_LABEL_WEIGHT~, \                    -- 251
            ~GLOB_LABEL_DISK_INTENSITY~, \            -- 252
            ~GLOB_LABEL_GLOW_INTENSITY~, \            -- 253
            ~GLOB_LABEL_SCALE~, \                     -- 254
            ~GLOB_LABEL_HAZE~, \                      -- 255
            ~GLOB_LABEL_HORIZON_HEIGHT~, \            -- 256
            ~GLOB_LABEL_BLUR~, \                      -- 257
            ~GLOB_LABEL_REDBLUE_TINT~, \              -- 258
            ~GLOB_LABEL_SATURATION~, \                -- 259
            ~GLOB_LABEL_VIS_DISTANCE~, \              -- 260
            ~GLOB_LABEL_GROUND_COLOR~, \              -- 261
            ~GLOB_LABEL_NIGHT_COLOR~, \               -- 262
            ~GLOB_LABEL_SOFTNESS~, \                  -- 263
            ~GLOB_LABEL_SOFTNESS_SAMPLES~, \          -- 264
            ~GLOB_LABEL_NORTH_OFFSET~, \              -- 265
            ~GLOB_LABEL_INHERIT_FROM_MRSKY~, \        -- 266
            ~GLOB_LABEL_USE_PHOTONS~, \               -- 267
            ~GLOB_LABEL_10_PERCENT_HAZE~, \           -- 268
            ~GLOB_LABEL_NEW_CONSTANT_SPEED~, \        -- 269
            ~GLOB_LABEL_CONSTANT_HORIZONTAL~, \       -- 270
            ~GLOB_LABEL_CONSTANT_VERTICAL~, \         -- 271
            ~GLOB_LABEL_CONSTANT_ROTATION~, \         -- 272
            ~GLOB_LABEL_TRACK_DIRECTION~, \           -- 273
            ~GLOB_LABEL_TRACK_PROFILE~, \             -- 274
            ~GLOB_LABEL_TRACK_SURFACE~, \             -- 275
            ~GLOB_LABEL_DIRECTION~, \                 -- 276
            ~GLOB_LABEL_LONGFALL~, \                  -- 277
            ~GLOB_LABEL_STATION_LOOPING~, \           -- 278
            ~GLOB_LABEL_TRACKING~, \                  -- 279
            ~GLOB_LABEL_POSITION~, \                  -- 280
            ~GLOB_LABEL_BRIGHTNESS~, \                -- 281
            ~GLOB_LABEL_CONTRAST~, \                  -- 282
            ~GLOB_LABEL_SHADOWS~, \                   -- 283
            ~GLOB_LABEL_QUANTITY~, \                  -- 284
            ~GLOB_LABEL_STYLE~, \                     -- 285
            ~GLOB_LABEL_EXPOSURE_VALUE~, \            -- 286
            ~GLOB_LABEL_MID_TONES~, \                 -- 287
            ~GLOB_LABEL_PHYSICAL_SCALE~, \            -- 288
            ~GLOB_LABEL_SHUTTER_SPEED~, \             -- 289
            ~GLOB_LABEL_APERTURE~, \                  -- 290
            ~GLOB_LABEL_FILM_SPEED~, \                -- 291
            ~GLOB_LABEL_HIGHLIGHTS~, \                -- 292
            ~GLOB_LABEL_WHITEPOINT~, \                -- 293
            ~GLOB_LABEL_VIGNETTING~, \                -- 294
            ~GLOB_LABEL_ACTIVE~, \                    -- 295
            ~GLOB_LABEL_PROCESS_BG~, \                -- 296
            ~GLOB_LABEL_COLOR_CORRECTION~, \          -- 297
            ~GLOB_LABEL_DESATURATE~, \                -- 298
            ~GLOB_LABEL_AFFECT_INDIRECT~, \           -- 299
            ~GLOB_LABEL_EXTERIOR_DAYLIGHT~, \         -- 300
            ~GLOB_LABEL_MIN_LX~, \                    -- 301
            ~GLOB_LABEL_MAX_LX~, \                    -- 302
            ~GLOB_LABEL_EXPOSURE_NONE~, \             -- 303
            ~GLOB_LABEL_EXPOSURE_LINEAR~, \           -- 304
            ~GLOB_LABEL_EXPOSURE_LOGARITHMIC~, \      -- 305
            ~GLOB_LABEL_EXPOSURE_PSEUDO~, \           -- 306
            ~GLOB_LABEL_EXPOSURE_AUTOMATIC~, \        -- 307
            ~GLOB_LABEL_EXPOSURE_PHYSICAL_CAMERA~, \  -- 308
            ~GLOB_LABEL_EXPOSURE_MR_PRESET1~, \       -- 309
            ~GLOB_LABEL_EXPOSURE_MR_PRESET2~, \       -- 310
            ~GLOB_LABEL_EXPOSURE_MR_PRESET3~, \       -- 311
            ~GLOB_LABEL_EXPOSURE_MR_PRESET4~, \       -- 312
            ~GLOB_LABEL_EXPOSURE_MR_PRESET5~, \       -- 313
            ~GLOB_LABEL_EXPOSURE_MR_PRESET6~, \       -- 314
            ~GLOB_LABEL_PHOTO_EXPOSURE~, \            -- 315
            ~GLOB_LABEL_PHYSICAL_UNITS~, \            -- 316
            ~GLOB_LABEL_UNITLESS~, \                  -- 317
            ~GLOB_LABEL_ILLUMINENCE~, \               -- 318
            ~GLOB_LABEL_LUMINENCE~, \                 -- 319
            ~GLOB_LABEL_COLORED~, \                   -- 320
            ~GLOB_LABEL_GREYSCALE~, \                 -- 321
            ~GLOB_LABEL_LOGARITHMIC~, \               -- 322
            ~GLOB_LABEL_LINEAR~, \                    -- 323
            ~GLOB_LABEL_FILE_PATH~, \                 -- 324
            ~GLOB_LABEL_FILE_NAME~, \                 -- 325
            ~GLOB_LABEL_FILE_TYPE~, \                 -- 326
            ~GLOB_LABEL_SURFACE~, \                   -- 327
            ~GLOB_LABEL_SAMPLING_INTERVAL~, \         -- 328
            ~GLOB_LABEL_CONSTANT_LEVEL~, \            -- 329
            ~GLOB_LABEL_DRAPE_OVER_SURFACE~, \        -- 330
            ~GLOB_LABEL_DRAPE_OVER_LEVEL~, \          -- 331
            ~GLOB_LABEL_USE_RMS~, \                   -- 332
            ~GLOB_LABEL_USE_SIGN~, \                  -- 333
            ~GLOB_LABEL_TEXT_COLOR~, \                -- 334
            ~GLOB_LABEL_STATION_INTERVAL~, \          -- 335
            ~GLOB_LABEL_SHIFT_DECIMAL~, \             -- 336
            ~GLOB_LABEL_TEXT_HEIGHT~, \               -- 337
            ~GLOB_LABEL_EXTRUDE_AMOUNT~, \            -- 338
            ~GLOB_LABEL_KERNING~, \                   -- 339
            ~GLOB_LABEL_DECIMAL_PLACES~, \            -- 340
            ~GLOB_LABEL_TEXT_PREFIX~, \               -- 341
            ~GLOB_LABEL_DECIMAL_SEPARATOR~, \         -- 342
            ~GLOB_LABEL_TEXT_SUFFIX~, \               -- 343
            ~GLOB_LABEL_VISIBILITY~, \                -- 344
            ~GLOB_LABEL_RENDERABLE~, \                -- 345
            ~GLOB_LABEL_FREEZE~, \                    -- 346
            ~GLOB_LABEL_RECEIVE_SHADOWS~, \           -- 347
            ~GLOB_LABEL_VISIBLE_TO_REFLECTIONS~, \    -- 348
            ~GLOB_LABEL_COLLAPSE~, \                  -- 349
            ~GLOB_LABEL_COMBINE~, \                   -- 350
            ~GLOB_LABEL_STATION_PREFIX~, \            -- 351
            ~GLOB_LABEL_STATION_SUFFIX~, \            -- 352
            ~GLOB_LABEL_RIGHT_CLICK~, \               -- 353
            ~GLOB_LABEL_INSTANCE~, \                  -- 354
            ~GLOB_LABEL_COPY~, \                      -- 355
            ~GLOB_LABEL_SEED_NAME~, \                 -- 356
            ~GLOB_LABEL_OBJECT_CLONED~, \             -- 357
            ~GLOB_LABEL_POINT_COUNT~, \               -- 358
            ~GLOB_LABEL_STEPS~, \                     -- 359
            ~GLOB_LABEL_APPLY_TO_NTH_POINT~, \        -- 360
            ~GLOB_LABEL_IGNORE_FIRST_POINT~, \        -- 361
            ~GLOB_LABEL_RANDOM_ROTATION~, \           -- 362
            ~GLOB_LABEL_CLONE_CHILDREN~, \            -- 363
            ~GLOB_LABEL_APPLY_TRACKING~, \            -- 364
            ~GLOB_LABEL_SURFACE_LIST~, \              -- 365
            ~GLOB_LABEL_TRACKING_FACES~, \            -- 366
            ~GLOB_LABEL_BEARING_MIN~, \               -- 367
            ~GLOB_LABEL_BEARING_MAX~, \               -- 368
            ~GLOB_LABEL_RANDOM~, \                    -- 369
            ~GLOB_LABEL_VEHICLE_TYPE~, \              -- 370
            ~GLOB_LABEL_VEHICLE_COLOR~, \             -- 371
            ~GLOB_LABEL_STEP_INTERVAL~, \             -- 372
            ~GLOB_LABEL_SHIFT_X~, \                   -- 373
            ~GLOB_LABEL_SHIFT_Y~, \                   -- 374
            ~GLOB_LABEL_CONSTANT_Z~, \                -- 375
            ~GLOB_LABEL_SCENE_START_SHIFT~, \         -- 376
            ~GLOB_LABEL_SPEED_MULTIPLIER~, \          -- 377
            ~GLOB_LABEL_IMPORT_START~, \              -- 378
            ~GLOB_LABEL_IMPORT_END~, \                -- 379
            ~GLOB_LABEL_MIN_STEPS~, \                 -- 380
            ~GLOB_LABEL_VEHICLE_TYPE_DD~, \           -- 381
            ~GLOB_LABEL_BASE_STEP_INTERVAL~, \        -- 382
            ~GLOB_LABEL_FILE_SIZE~, \                 -- 383
            ~GLOB_LABEL_KILOBYTES~, \                 -- 384
            ~GLOB_LABEL_CHOOSE_INTERVAL~, \           -- 385
            ~GLOB_LABEL_SCENE_LENGTH_1~, \            -- 386
            ~GLOB_LABEL_SCENE_LENGTH_2~, \            -- 387
            ~GLOB_LABEL_PARENT_SHAPE2~, \             -- 388
            ~GLOB_LABEL_PARENT_SURFACE2~, \           -- 389
            ~GLOB_LABEL_OBJECT~, \                    -- 390
            ~GLOB_LABEL_CVE_OBJECT_CATEGORY~, \       -- 391
            ~GLOB_LABEL_SELECT_OBJECT~, \             -- 392
            ~GLOB_LABEL_SELECT_CATEGORY~, \           -- 393
            ~GLOB_LABEL_SELECT_SHAPE~, \              -- 394
            ~GLOB_LABEL_SELECT_SURFACE~, \            -- 395
            ~GLOB_LABEL_OBJECT_NAME~, \               -- 396
            ~GLOB_LABEL_DISPLAY_FILTER_BY~, \         -- 397
            ~GLOB_LABEL_ALL_STRINGS~, \               -- 398
            ~GLOB_LABEL_GEOMETRY_ERRORS~, \           -- 399
            ~GLOB_LABEL_READING_ERRORS~, \            -- 400
            ~GLOB_LABEL_PREFIX~, \                    -- 401
            ~GLOB_LABEL_MAXSCRIPT~, \                 -- 402
            ~GLOB_LABEL_LOCK_WIDTH~, \                -- 403
            ~GLOB_LABEL_LEFT_WIDTH~, \                -- 404
            ~GLOB_LABEL_RIGHT_WODTH~, \               -- 405
            ~GLOB_LABEL_POST_SPACING~, \              -- 406
            ~GLOB_LABEL_DIMS~, \                      -- 407
            ~GLOB_LABEL_POST_STYLE~, \                -- 408
            ~GLOB_LABEL_POST_MATID~, \                -- 409
            ~GLOB_LABEL_BRACE_DEPTH~, \               -- 410
            ~GLOB_LABEL_BRACE_HEIGHT~, \              -- 411
            ~GLOB_LABEL_BRACE_GAP~, \                 -- 412
            ~GLOB_LABEL_BRACE_STYLE~, \               -- 413
            ~GLOB_LABEL_BRACE_MATID~, \               -- 414
            ~GLOB_LABEL_LEFT_ON~, \                   -- 415
            ~GLOB_LABEL_RIGHT_ON~, \                  -- 416
            ~GLOB_LABEL_RAIL_DEPTH~, \                -- 417
            ~GLOB_LABEL_FLANGE_DEPTH~, \              -- 418
            ~GLOB_LABEL_FLANGE_OFFSET~, \             -- 419
            ~GLOB_LABEL_RAIL_MATID~, \                -- 420
            ~GLOB_LABEL_RAIL_STYLE~, \                -- 421
            ~GLOB_LABEL_UV_REPEAT~, \                 -- 422
            ~GLOB_LABEL_POSTS~, \                     -- 423
            ~GLOB_LABEL_BRACES~, \                    -- 424
            ~GLOB_LABEL_RAILS~, \                     -- 425
            ~GLOB_LABEL_POST_TYPE0~, \                -- 426
            ~GLOB_LABEL_POST_TYPE1~, \                -- 427
            ~GLOB_LABEL_BRACE_TYPE0~, \               -- 428
            ~GLOB_LABEL_BRACE_TYPE1~, \               -- 429
            ~GLOB_LABEL_RAIL_TYPE0~, \                -- 430
            ~GLOB_LABEL_RAIL_TYPE1~, \                -- 431
            ~GLOB_LABEL_RAIL_TYPE2~, \                -- 432
            ~GLOB_LABEL_RAIL_TYPE3~, \                -- 433
            ~GLOB_LABEL_RAIL_TYPE4~, \                -- 434
            ~GLOB_LABEL_RAIL_TYPE5~, \                -- 435
            ~GLOB_LABEL_GENERAL~, \                   -- 436
            ~GLOB_LABEL_FILL_CLOSED~, \               -- 437
            ~GLOB_LABEL_CENTER_GAP~, \                -- 438
            ~GLOB_LABEL_FILL_ANGLE~, \                -- 439
            ~GLOB_LABEL_LINE_COLOR~, \                -- 440
            ~GLOB_LABEL_PARENT~, \                    -- 441
            ~GLOB_LABEL_FEATURE~, \                   -- 442
            ~GLOB_LABEL_APPLY_STYLE~, \               -- 443
            ~GLOB_LABEL_DIAMETER~, \                  -- 444
            ~GLOB_LABEL_SIDES~, \                     -- 445
            ~GLOB_LABEL_MATID~, \                     -- 446
            ~GLOB_LABEL_INDEPENDENT_STATIONS~, \      -- 447
            ~GLOB_LABEL_SOURCE_SHAPE_LIST~, \         -- 448
            ~GLOB_LABEL_PARENT_SHAPE_NAME~, \         -- 449
            ~GLOB_LABEL_SELECT_SHAPE_PART~, \         -- 450
            ~GLOB_LABEL_SMOOTH_GROUP_ABBREVIATED~, \  -- 451
            ~GLOB_LABEL_SPLINES~, \                   -- 452
            ~GLOB_LABEL_CURRENT_ASSIGNMENT~, \        -- 453
            ~GLOB_LABEL_FACES~, \                     -- 454
            ~GLOB_LABEL_VERTICES~, \                  -- 455
            ~GLOB_LABEL_ELEMENTS~, \                  -- 456
            ~GLOB_LABEL_OTHER~, \                     -- 457
            ~GLOB_LABEL_SAMPLE_POINTS~, \             -- 458
            ~GLOB_LABEL_SAMPLE_DISTANCE~, \           -- 459
            ~GLOB_LABEL_3DS_OBJECT_NAME~, \           -- 460
            ~GLOB_LABEL_SOURCE_OBJECT~, \             -- 461
            ~GLOB_LABEL_SOURCE_PARENT~, \             -- 462
            ~GLOB_LABEL_SOURCE_FILE~, \               -- 463
            ~GLOB_LABEL_SELECT_STRING_OBJECT~, \      -- 464
            ~GLOB_LABEL_KNOTS_POINTS~, \              -- 465
            ~GLOB_LABEL_TRIANGLES_FACES~, \           -- 466
            ~GLOB_LABEL_SELECT_PARENT~, \             -- 467
            ~GLOB_LABEL_NEW_FEATURE_NAME~, \          -- 468
            ~GLOB_LABEL_SCALE_FACTOR~, \              -- 469
            ~GLOB_LABEL_NEW_HORIZONTAL~, \            -- 470
            ~GLOB_LABEL_NEW_VERTICAL~, \              -- 471
            ~GLOB_LABEL_NEW_ROTATION~, \              -- 472
            ~GLOB_LABEL_NEW_SPLINE~, \                -- 473
            ~GLOB_LABEL_ROTATION_MIN~, \              -- 474
            ~GLOB_LABEL_ROTATION_MAX~, \              -- 475
            ~GLOB_LABEL_HORIZONTAL_MIN~, \            -- 476
            ~GLOB_LABEL_HORIZONTAL_MAX~, \            -- 477
            ~GLOB_LABEL_VERTICAL_MIN~, \              -- 478
            ~GLOB_LABEL_VERTICAL_MAX~, \              -- 479
            ~GLOB_LABEL_VEHICLE_TYPE_NAME~, \         -- 480
            ~GLOB_LABEL_SOURCE_ZONE~, \               -- 481
            ~GLOB_LABEL_DESTINATION_ZONE~, \          -- 482
            ~GLOB_LABEL_CONSTANT_SPEED~, \            -- 483
            ~GLOB_LABEL_OBJECT_COUNT~, \              -- 484
            ~GLOB_LABEL_OBJECT_INTERVAL~, \           -- 485
            ~GLOB_LABEL_GROUP_NAME~, \                -- 486
            ~GLOB_LABEL_FILE_COUNT~, \                -- 487
            ~GLOB_LABEL_TREE_TYPE_BILLBOARD~, \       -- 488
            ~GLOB_LABEL_TREE_TYPE_FOLIAGE~, \         -- 489
            ~GLOB_LABEL_SIGN_TYPE_SIGN~, \            -- 490
            ~GLOB_LABEL_SIGN_TYPE_MARKING~, \         -- 491
            ~GLOB_LABEL_SIGN_TYPE_SIGNAL~, \          -- 492
            ~GLOB_LABEL_INI_FILE_PATH~, \             -- 493
            ~GLOB_LABEL_MAP_FILE_PATH~, \             -- 494
            ~GLOB_LABEL_MAX_FILE_PATH~, \             -- 495
            ~GLOB_LABEL_USE_RANDOM_OBJECTS~, \        -- 496
            ~GLOB_LABEL_SHAPE_NAME~, \                -- 497
            ~GLOB_LABEL_SURFACE_NAME~, \              -- 498
            ~GLOB_LABEL_DERIVE_OBJECTS_FROM~, \       -- 499
            ~GLOB_LABEL_SIZE~, \                      -- 500
            ~GLOB_LABEL_SPACE~, \                     -- 501
            ~GLOB_LABEL_NUMBER_POSTS~, \              -- 502
            ~GLOB_LABEL_LENS~, \                      -- 503
            ~GLOB_LABEL_TARGET~, \                    -- 504
            ~GLOB_LABEL_RESOURCE_KIT_FOLDER~, \       -- 505
            ~GLOB_LABEL_PICK_POINT_1~, \              -- 506
            ~GLOB_LABEL_PICK_POINT_2~, \              -- 507
            ~GLOB_LABEL_SUPPRESS_SCENE_WARNING~, \    -- 508
            ~GLOB_LABEL_REFERENCE_MODEL~, \           -- 509
            ~GLOB_LABEL_REFERENCE_STRING~, \          -- 510
            ~GLOB_LABEL_INITIAL_CHARACTER~, \         -- 511
            ~GLOB_LABEL_OFFSET_OR_CROSSFALL~, \       -- 512
            ~GLOB_LABEL_USE_FEATURE_INTERPRETATION~, \-- 513
            ~GLOB_LABEL_COMMON_PARENT_OBJECT~, \      -- 514
            ~GLOB_LABEL_NEW_OBJECT~, \                -- 515
            ~GLOB_LABEL_NEW_HORIZONTAL_OFFSET~, \     -- 516
            ~GLOB_LABEL_NEW_VERTICAL_OFFSET~, \       -- 517
            ~GLOB_LABEL_NEW_STATION_OFFSET~, \        -- 518
            ~GLOB_LABEL_COMMON_PARENT_SHAPE~, \       -- 519
            ~GLOB_LABEL_PRINT~, \                     -- 520
            ~GLOB_LABEL_CORE_ALIGNMENT_DATA~, \       -- 521
            ~GLOB_LABEL_PROFILE_DATA~, \              -- 522
            ~GLOB_LABEL_UNGROUPED~, \                 -- 523
            ~GLOB_LABEL_PIPES~, \                     -- 524
            ~GLOB_LABEL_STRUCTURES~, \                -- 525
            ~GLOB_LABEL_RELATED_NETWORK_PARTS~, \     -- 526
            ~GLOB_LABEL_PART_DATA~, \                 -- 527
            ~GLOB_LABEL_NETWORK~, \                   -- 528
            ~GLOB_LABEL_STRUCTURE_NAME~, \            -- 529
            ~GLOB_LABEL_STRUCTURE_TYPE~, \            -- 530
            ~GLOB_LABEL_STRUCTURE_COVER~, \           -- 531
            ~GLOB_LABEL_STRUCTURE_FRAME~, \           -- 532
            ~GLOB_LABEL_STRUCTURE_GRATE~, \           -- 533
            ~GLOB_LABEL_STRUCTURE_MATERIAL~, \        -- 534
            ~GLOB_LABEL_STRUCTURE_PART_TYPE~, \       -- 535
            ~GLOB_LABEL_STRUCTURE_PART_DESC~, \       -- 536
            ~GLOB_LABEL_STRUCTURE_PART_SIZE~, \       -- 537
            ~GLOB_LABEL_STRUCTURE_PART_SUBNAME~, \    -- 538
            ~GLOB_LABEL_STRUCTURE_PART_COUNT~, \      -- 539
            ~GLOB_LABEL_STRUCTURE_PIPES_COUNT~, \     -- 540
            ~GLOB_LABEL_STRUCTURE_WIDTH~, \           -- 541
            ~GLOB_LABEL_STRUCTURE_LENGTH~, \          -- 542
            ~GLOB_LABEL_STRUCTURE_HEIGHT~, \          -- 543
            ~GLOB_LABEL_STRUCTURE_FRAME_WIDTH~, \     -- 544
            ~GLOB_LABEL_STRUCTURE_FRAME_LENGTH~, \    -- 545
            ~GLOB_LABEL_STRUCTURE_FRAME_HEIGHT~, \    -- 546
            ~GLOB_LABEL_STRUCTURE_CONE_WIDTH~, \      -- 547
            ~GLOB_LABEL_STRUCTURE_CONE_LENGTH~, \     -- 548
            ~GLOB_LABEL_STRUCTURE_CONE_HEIGHT~, \     -- 549
            ~GLOB_LABEL_STRUCTURE_FLOOR_DEPTH~, \     -- 550
            ~GLOB_LABEL_STRUCTURE_WALL_WIDTH~, \      -- 551
            ~GLOB_LABEL_STRUCTURE_RIM_WIDTH~, \       -- 552
            ~GLOB_LABEL_STRUCTURE_BARREL_CLEARANCE~, \-- 553
            ~GLOB_LABEL_PIPE_NAME~, \                 -- 554
            ~GLOB_LABEL_PIPE_DESCRIPTION~, \          -- 555
            ~GLOB_LABEL_PIPE_SHAPE~, \                -- 556
            ~GLOB_LABEL_PIPE_PART_DESC~, \            -- 557
            ~GLOB_LABEL_PIPE_PART_SIZE~, \            -- 558
            ~GLOB_LABEL_PIPE_PART_SUBTYPE~, \         -- 559
            ~GLOB_LABEL_PIPE_PSETYPE~, \              -- 560
            ~GLOB_LABEL_PIPE_FLOW_DIRECTION~, \       -- 561
            ~GLOB_LABEL_PIPE_FLOW_METHOD~, \          -- 562
            ~GLOB_LABEL_PIPE_BEARING~, \              -- 563
            ~GLOB_LABEL_PIPE_RADIUS~, \               -- 564
            ~GLOB_LABEL_PIPE_SLOPE~, \                -- 565
            ~GLOB_LABEL_PIPE_INNER_WIDTH~, \          -- 566
            ~GLOB_LABEL_PIPE_INNER_HEIGHT~, \         -- 567
            ~GLOB_LABEL_PIPE_OUTER_WIDTH~, \          -- 568
            ~GLOB_LABEL_PIPE_OUTER_HEIGHT~, \         -- 569
            ~GLOB_LABEL_PIPE_MIN_COVER~, \            -- 570
            ~GLOB_LABEL_PIPE_MAX_COVER~, \            -- 571
            ~GLOB_LABEL_PIPE_2DLENGTH_CENTERCENTER~, \-- 572
            ~GLOB_LABEL_PIPE_3DLENGTH_CENTERCENTER~, \-- 573
            ~GLOB_LABEL_PIPE_2DLENGTH_EDGEEDGE~, \    -- 574
            ~GLOB_LABEL_PIPE_3DLENGTH_EDGEEDGE~, \    -- 575
            ~GLOB_LABEL_PIPE_SHAPE_UNDEFINED~, \      -- 576
            ~GLOB_LABEL_PIPE_SHAPE_ARCHED~, \         -- 577
            ~GLOB_LABEL_PIPE_SHAPE_CIRCULAR~, \       -- 578
            ~GLOB_LABEL_PIPE_SHAPE_CUSTOM~, \         -- 579
            ~GLOB_LABEL_PIPE_SHAPE_EGG~, \            -- 580
            ~GLOB_LABEL_PIPE_SHAPE_ELLIPSE~, \        -- 581
            ~GLOB_LABEL_PIPE_SHAPE_HORIZ_ELLIPSE~, \  -- 582
            ~GLOB_LABEL_PIPE_SHAPE_RECTANGULAR~, \    -- 583
            ~GLOB_LABEL_PIPE_PSETYPE_CURVED~, \       -- 584
            ~GLOB_LABEL_PIPE_PSETYPE_FLEXIBLE~, \     -- 585
            ~GLOB_LABEL_PIPE_PSETYPE_SEGMENTED~, \    -- 586
            ~GLOB_LABEL_PIPE_PSETYPE_STRAIGHT~, \     -- 587
            ~GLOB_LABEL_PIPE_FLOW_BIDIRECTIONAL~, \   -- 588
            ~GLOB_LABEL_PIPE_FLOW_END_TO_START~, \    -- 589
            ~GLOB_LABEL_PIPE_FLOW_START_TO_END~, \    -- 590
            ~GLOB_LABEL_PIPE_METHOD_BIDIRECTIONAL~, \ -- 591
            ~GLOB_LABEL_PIPE_METHOD_BY_SLOPE~, \      -- 592
            ~GLOB_LABEL_PIPE_METHOD_END_TO_START~, \  -- 593
            ~GLOB_LABEL_PIPE_METHOD_START_TO_END~, \  -- 594
            ~GLOB_LABEL_ANIMATE_WHEELS~, \            -- 595
            ~GLOB_LABEL_OFFSET_X~, \                  -- 596
            ~GLOB_LABEL_OFFSET_Y~, \                  -- 597
            ~GLOB_LABEL_RECTANGULAR~, \               -- 598
            ~GLOB_LABEL_CYLINDRICAL~, \               -- 599
            ~GLOB_LABEL_OUTER_WIDTH~, \               -- 600
            ~GLOB_LABEL_OUTER_HEIGHT~, \              -- 601
            ~GLOB_LABEL_IMAGE_DIMENSIONS~, \          -- 602
            ~GLOB_LABEL_ALPHA_CHANNEL~, \             -- 603
            ~GLOB_LABEL_PART_TYPE_UNDEFINED~, \       -- 604
            ~GLOB_LABEL_PART_TYPE_CHANNEL~, \         -- 605
            ~GLOB_LABEL_PART_TYPE_CONDUIT~, \         -- 606
            ~GLOB_LABEL_PART_TYPE_TYPE~, \            -- 607
            ~GLOB_LABEL_PART_TYPE_EQUIPMENT~, \       -- 608
            ~GLOB_LABEL_PART_TYPE_GENERAL~, \         -- 609
            ~GLOB_LABEL_PART_TYPE_INLET_OUTLET~, \    -- 610
            ~GLOB_LABEL_PART_TYPE_JUNCTION~, \        -- 611
            ~GLOB_LABEL_PART_TYPE_NULL~, \            -- 612
            ~GLOB_LABEL_PART_TYPE_WIRE~, \            -- 613
            ~GLOB_LABEL_NETWORKS_AND_PARTS~, \        -- 614
            ~GLOB_LABEL_COGO_POINTS~, \               -- 615
            ~GLOB_LABEL_SURFACE_TIN~, \               -- 616
            ~GLOB_LABEL_SURFACE_BREAKLINES~, \        -- 617
            ~GLOB_LABEL_EXPOSURE_PC_USE_CAMERA~, \    -- 618
            ~GLOB_LABEL_EXPOSURE_PC_EV_COMPENSATION~, \ -- 619
            ~GLOB_LABEL_EXPOSURE_PC_EXPOSURE_VALUE~, \-- 620
            ~GLOB_LABEL_EXPOSURE_PC_CUSTOM~, \        -- 621
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_01~, \     -- 622
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_02~, \     -- 623
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_03~, \     -- 624
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_04~, \     -- 625
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_05~, \     -- 626
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_06~, \     -- 627
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_07~, \     -- 628
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_08~, \     -- 629
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_09~, \     -- 630
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_10~, \     -- 631
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_11~, \     -- 632
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_12~, \     -- 633
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_13~, \     -- 634
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_14~, \     -- 635
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_15~, \     -- 636
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_16~, \     -- 637
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_17~, \     -- 638
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_18~, \     -- 639
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_19~, \     -- 640
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_20~, \     -- 641
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_21~, \     -- 642
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_22~, \     -- 643
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_23~, \     -- 644
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_24~, \     -- 645
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_25~, \     -- 646
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_26~, \     -- 647
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_27~, \     -- 648
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_28~, \     -- 649
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_29~, \     -- 650
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_30~, \     -- 651
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_31~, \     -- 652
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_32~, \     -- 653
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_33~, \     -- 654
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_34~, \     -- 655
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_35~, \     -- 656
            ~GLOB_LABEL_EXPOSURE_PC_PRESET_36~, \     -- 657
            ~GLOB_LABEL_EXPOSURE_PC_ILLUMINANT~, \    -- 658
            ~GLOB_LABEL_EXPOSURE_PC_TEMPERATURE~, \   -- 659
            ~GLOB_LABEL_EXPOSURE_PC_WHITEBALANCE~, \  -- 660
            ~GLOB_LABEL_EXPOSURE_PC_DISABLED~, \      -- 661
            ~GLOB_LABEL_EXPOSURE_PC_HIGHLIGHTS~, \    -- 662
            ~GLOB_LABEL_DISTANCE~, \                  -- 663
            ~GLOB_LABEL_USE_MAP~, \                   -- 664 "On (Use Map)"
            ~GLOB_LABEL_INTENSITY~, \                 -- 665 "Intensity:"
            ~GLOB_LABEL_DISC_SIZE_PERCENT~, \         -- 666 "Disc Size (%):"
            ~GLOB_LABEL_HORIZON_BLUR~, \              -- 667 "Horizon Blur:"
            ~GLOB_LABEL_DISC_INTENSITY~, \            -- 668 "Disc Intensity:"
            ~GLOB_LABEL_TINT~, \                      -- 669 "Tint:"
            ~GLOB_LABEL_HORIZONTAL_ILLUMINANCE~, \    -- 670 "Diffuse Horizontal Illuminance:"
            ~GLOB_LABEL_NORMAL_ILLUMINANCE~, \        -- 671 "Direct Normal Illuminance:"
            ~GLOB_LABEL_AUTOMATIC~, \                 -- 672 "Automatic"
            ~GLOB_LABEL_PHYSICAL_PREETHAM~, \         -- 673 "Physical (Preetham et al.)"
            ~GLOB_LABEL_SUN_ON~, \                    -- 674 "Sun On"
            ~GLOB_LABEL_MEASURED_PEREZ~, \            -- 675 "Measured (Perez All-Weather)"
            ~GLOB_LABEL_STANDARD_MATERIAL~, \         -- 676 "Standard material"
            ~GLOB_LABEL_PHYSICAL_MATERIAL~, \         -- 677 "Physical material"
            ~GLOB_LABEL_REPLACE_GIFS~, \              -- 678
            ~GLOB_LABEL_NO_GIFS_TO_REPLACE~, \        -- 679
            ~GLOB_LABEL_NO_ALTERNATIVE_IMAGE~, \      -- 680
            ~GLOB_LABEL_MULTIMATERIAL_USES_GIF~, \    -- 681
            ~GLOB_LABEL_GIF_COUNT_REPLACED~, \        -- 682
            ~GLOB_LABEL_GIF_COUNT~, \                 -- 683
            ~GLOB_LABEL_MATERIAL_UNUSED~, \           -- 684
            ~GLOB_LABEL_NO_REPLACEMENTS~, \           -- 685
            ~GLOB_LABEL_STANDARD_SURFACE~ \           -- 686 "Standard Surface material"
          )

          global DYNuiResourcesLvColumns = #( \
            ~GLOB_LVCOL_OBJECT_DEFINITION~, \         -- 01
            ~GLOB_LVCOL_INTERVAL~, \                  -- 02
            ~GLOB_LVCOL_ROTATION~, \                  -- 03
            ~GLOB_LVCOL_HOR_OFFSET~, \                -- 04
            ~GLOB_LVCOL_VER_OFFSET~, \                -- 05
            ~GLOB_LVCOL_START_PERCENT~, \             -- 06
            ~GLOB_LVCOL_END_PERCENT~, \               -- 07
            ~GLOB_LVCOL_SPEED~, \                     -- 08
            ~GLOB_LVCOL_CATEGORY~, \                  -- 09
            ~GLOB_LVCOL_FACES~, \                     -- 10
            ~GLOB_LVCOL_VERTICES~, \                  -- 11
            ~GLOB_LVCOL_COUNT~, \                     -- 12
            ~GLOB_LVCOL_FILE_NAME~, \                 -- 13
            ~GLOB_LVCOL_FILE_SIZE~, \                 -- 14
            ~GLOB_LVCOL_MATERIAL_TYPE~, \             -- 15
            ~GLOB_LVCOL_SHAPE_MASK~, \                -- 16
            ~GLOB_LVCOL_GAP_LENGTH~, \                -- 17
            ~GLOB_LVCOL_MARK_LENGTH~, \               -- 18
            ~GLOB_LVCOL_WIDTH~, \                     -- 19
            ~GLOB_LVCOL_INSTANCING~, \                -- 20
            ~GLOB_LVCOL_FILL_CLOSED~, \               -- 21
            ~GLOB_LVCOL_FILL_ANGLE~, \                -- 22
            ~GLOB_LVCOL_CENTER_GAP~, \                -- 23
            ~GLOB_LVCOL_ELEMENT_MATID~, \             -- 24
            ~GLOB_LVCOL_START_HO~, \                  -- 25
            ~GLOB_LVCOL_END_HO~, \                    -- 26
            ~GLOB_LVCOL_START_VO~, \                  -- 27
            ~GLOB_LVCOL_END_VO~, \                    -- 28
            ~GLOB_LVCOL_SMOOTH~, \                    -- 29
            ~GLOB_LVCOL_NAME~, \                      -- 30
            ~GLOB_LVCOL_OBJECT_TYPE~, \               -- 31
            ~GLOB_LVCOL_POINTS~, \                    -- 32
            ~GLOB_LVCOL_SPLINES_FACES~, \             -- 33
            ~GLOB_LVCOL_LINK~, \                      -- 34
            ~GLOB_LVCOL_CORRIDOR~, \                  -- 35
            ~GLOB_LVCOL_BASELINE~, \                  -- 36
            ~GLOB_LVCOL_REGION~, \                    -- 37
            ~GLOB_LVCOL_ASSEMBLY~, \                  -- 38
            ~GLOB_LVCOL_START_STATION~, \             -- 39
            ~GLOB_LVCOL_END_STATION~, \               -- 40
            ~GLOB_LVCOL_ACAD_LAYER~, \                -- 41
            ~GLOB_LVCOL_LIGHT_SOURCES~, \             -- 42
            ~GLOB_LVCOL_INTENSITY~, \                 -- 43
            ~GLOB_LVCOL_SHADOW~, \                    -- 44
            ~GLOB_LVCOL_BUILDING_HEIGHT~, \           -- 45
            ~GLOB_LVCOL_FLOORS~, \                    -- 46
            ~GLOB_LVCOL_MAPPING_STYLE~, \             -- 47
            ~GLOB_LVCOL_MAPPING_WIDTH~, \             -- 48
            ~GLOB_LVCOL_MATID~, \                     -- 49
            ~GLOB_LVCOL_STATION~, \                   -- 50
            ~GLOB_LVCOL_FILE~, \                      -- 51
            ~GLOB_LVCOL_SIZE~, \                      -- 52
            ~GLOB_LVCOL_TYPE~, \                      -- 53
            ~GLOB_LVCOL_DATE_MODIFIED~, \             -- 54
            ~GLOB_LVCOL_OBJECT_NAME~, \               -- 55
            ~GLOB_LVCOL_VEHICLE_ID~, \                -- 56
            ~GLOB_LVCOL_VEHICLE_TYPE~, \              -- 57
            ~GLOB_LVCOL_START_FRAME_F~, \             -- 58
            ~GLOB_LVCOL_END_FRAME_F~, \               -- 59
            ~GLOB_LVCOL_KEY_COUNT~, \                 -- 60
            ~GLOB_LVCOL_SURFACE_NAME~, \              -- 61
            ~GLOB_LVCOL_FACE_COUNT~, \                -- 62
            ~GLOB_LVCOL_FILTERED_FACES~, \            -- 63
            ~GLOB_LVCOL_MATIDS~, \                    -- 64
            ~GLOB_LVCOL_BEARING_MIN~, \               -- 65
            ~GLOB_LVCOL_BEARING_MAX~, \               -- 66
            ~GLOB_LVCOL_MATID_NAME~, \                -- 67
            ~GLOB_LVCOL_BODY_COLOR~, \                -- 68
            ~GLOB_LVCOL_CVE_VEHICLE~, \               -- 69
            ~GLOB_LVCOL_QUANTITY~, \                  -- 70
            ~GLOB_LVCOL_STEPS~, \                     -- 71
            ~GLOB_LVCOL_START_FRAME_S~, \             -- 72
            ~GLOB_LVCOL_END_FRAME_S~, \               -- 73
            ~GLOB_LVCOL_OBJECT~, \                    -- 74
            ~GLOB_LVCOL_PARENT_SHAPE~, \              -- 75
            ~GLOB_LVCOL_PARENT_SURFACE~, \            -- 76
            ~GLOB_LVCOL_STATION_LOOPING~, \           -- 77
            ~GLOB_LVCOL_SHAPE_DIRECTION~, \           -- 78
            ~GLOB_LVCOL_SHAPE_LONGFALL~, \            -- 79
            ~GLOB_LVCOL_SURFACE_NORMS~, \             -- 80
            ~GLOB_LVCOL_SPLINE_ID~, \                 -- 81
            ~GLOB_LVCOL_DATE_CREATED~, \              -- 82
            ~GLOB_LVCOL_SUPPORTED~, \                 -- 83
            ~GLOB_LVCOL_UNSUPPORTED~, \               -- 84
            ~GLOB_LVCOL_LAST_MODIFIED~, \             -- 85
            ~GLOB_LVCOL_STRING_LABEL~, \              -- 86
            ~GLOB_LVCOL_STRING_TYPE~, \               -- 87
            ~GLOB_LVCOL_STRING_COUNT~, \              -- 88
            ~GLOB_LVCOL_SUB_REF~, \                   -- 89
            ~GLOB_LVCOL_MODEL~, \                     -- 90
            ~GLOB_LVCOL_CONDITION~, \                 -- 91
            ~GLOB_LVCOL_TARGET_OBJECTS~, \            -- 92
            ~GLOB_LVCOL_WIDTH_LEFT~, \                -- 93
            ~GLOB_LVCOL_WIDTH_RIGHT~, \               -- 94
            ~GLOB_LVCOL_HEIGHT~, \                    -- 95
            ~GLOB_LVCOL_POST~, \                      -- 96
            ~GLOB_LVCOL_BRACE~, \                     -- 97
            ~GLOB_LVCOL_RAIL_LEFT~, \                 -- 98
            ~GLOB_LVCOL_RAIL_RIGHT~, \                -- 99
            ~GLOB_LVCOL_PARENT_MASK~, \               -- 100
            ~GLOB_LVCOL_FEATURE_MASK~, \              -- 101
            ~GLOB_LVCOL_RGB_RED~, \                   -- 102
            ~GLOB_LVCOL_RGB_GREEN~, \                 -- 103
            ~GLOB_LVCOL_RGB_BLUE~, \                  -- 104
            ~GLOB_LVCOL_CIVILVIEW_STYLE~, \           -- 105
            ~GLOB_LVCOL_DIAMETER~, \                  -- 106
            ~GLOB_LVCOL_SIDES~, \                     -- 107
            ~GLOB_LVCOL_MATID_SURFACES~, \            -- 108
            ~GLOB_LVCOL_SHAPE~, \                     -- 109
            ~GLOB_LVCOL_SPLINES~, \                   -- 110
            ~GLOB_LVCOL_SOURCE_PARENT~, \             -- 111
            ~GLOB_LVCOL_SOURCE_FEATURE~, \            -- 112
            ~GLOB_LVCOL_DATE_IMPORTED~, \             -- 113
            ~GLOB_LVCOL_SOURCE_MODIFIED~, \           -- 114
            ~GLOB_LVCOL_SOURCE_FILE~, \               -- 115
            ~GLOB_LVCOL_TYPE_NAME~, \                 -- 116
            ~GLOB_LVCOL_TYPE_ID~, \                   -- 117
            ~GLOB_LVCOL_SOURCE~, \                    -- 118
            ~GLOB_LVCOL_DESTINATION~, \               -- 119
            ~GLOB_LVCOL_ID~, \                        -- 120
            ~GLOB_LVCOL_LENGTH~, \                    -- 121
            ~GLOB_LVCOL_WEIGHT~, \                    -- 122
            ~GLOB_LVCOL_CAB_LENGTH~, \                -- 123
            ~GLOB_LVCOL_TRAILER_COUNT~, \             -- 124
            ~GLOB_LVCOL_MAX_ACCELERATION~, \          -- 125
            ~GLOB_LVCOL_MAX_DECELERATION~, \          -- 126
            ~GLOB_LVCOL_TOP_SPEED~, \                 -- 127
            ~GLOB_LVCOL_BHP~, \                       -- 128
            ~GLOB_LVCOL_IS_BUS~, \                    -- 129
            ~GLOB_LVCOL_CAPACITY~, \                  -- 130
            ~GLOB_LVCOL_ENTRY_DOORS~, \               -- 131
            ~GLOB_LVCOL_EXIT_DOORS~, \                -- 132
            ~GLOB_LVCOL_MEAN_AGE~, \                  -- 133
            ~GLOB_LVCOL_MIN_CRAWL_SPEED~, \           -- 134
            ~GLOB_LVCOL_FAMILIAR_PROP~, \             -- 135
            ~GLOB_LVCOL_PCU_FACTOR~, \                -- 136
            ~GLOB_LVCOL_HEADWAY_FACTOR~, \            -- 137
            ~GLOB_LVCOL_REACTION_FACTOR~, \           -- 138
            ~GLOB_LVCOL_SOURCE_TYPE~, \               -- 139
            ~GLOB_LVCOL_DIMENSION_A~, \               -- 140
            ~GLOB_LVCOL_DIMENSION_B~, \               -- 141
            ~GLOB_LVCOL_PARAMETER~, \                 -- 142
            ~GLOB_LVCOL_VALUE~, \                     -- 143
            ~GLOB_LVCOL_REPLACEMENT_IMAGE~ \          -- 144
          )

          global DYNuiResourcesReportColumns = #( \
            ~GLOB_REPORT_COL_01~, \                   -- 01
            ~GLOB_REPORT_COL_02~, \                   -- 02
            ~GLOB_REPORT_COL_03~, \                   -- 03
            ~GLOB_REPORT_COL_04~, \                   -- 04
            ~GLOB_REPORT_COL_05~, \                   -- 05
            ~GLOB_REPORT_COL_06~, \                   -- 06
            ~GLOB_REPORT_COL_07~, \                   -- 07
            ~GLOB_REPORT_COL_08~, \                   -- 08
            ~GLOB_REPORT_COL_09~, \                   -- 09
            ~GLOB_REPORT_COL_10~, \                   -- 10
            ~GLOB_REPORT_COL_11~ \                    -- 11
          )

          global DYNuiResourcesMaterials = #( \
            ~MATL_VEHICLES_01_GREEN~, \               -- 01
            ~MATL_VEHICLES_02_DARK_BLUE~, \           -- 02
            ~MATL_VEHICLES_03_LIGHT_BLUE~, \          -- 03
            ~MATL_VEHICLES_04_SILVER~, \              -- 04
            ~MATL_VEHICLES_05_WHITE~, \               -- 05
            ~MATL_VEHICLES_06_BLACK~, \               -- 06
            ~MATL_VEHICLES_07_RED~, \                 -- 07
            ~MATL_VEHICLES_08_CHERRY_RED~, \          -- 08
            ~MATL_VEHICLES_09_YELLOW~, \              -- 09
            ~MATL_VEHICLES_10~, \                     -- 10
            ~MATL_VEHICLES_11~, \                     -- 11
            ~MATL_VEHICLES_12~, \                     -- 12
            ~MATL_VEHICLES_13~, \                     -- 13
            ~MATL_VEHICLES_14~, \                     -- 14
            ~MATL_VEHICLES_15~, \                     -- 15
            ~MATL_VEHICLES_16~, \                     -- 16
            ~MATL_VEHICLES_17~, \                     -- 17
            ~MATL_VEHICLES_18~, \                     -- 18
            ~MATL_VEHICLES_19~, \                     -- 19
            ~MATL_VEHICLES_20~, \                     -- 20
            ~MATL_VEHICLES_21~, \                     -- 21
            ~MATL_VEHICLES_22~, \                     -- 22
            ~MATL_VEHICLES_23~, \                     -- 23
            ~MATL_VEHICLES_24~, \                     -- 24
            ~MATL_VEHICLES_25~, \                     -- 25
            ~MATL_VEHICLES_26~, \                     -- 26
            ~MATL_VEHICLES_27~ \                      -- 27
          )

          global DYNuiResourcesSurfaceMaterial = #( \
            ~MATL_SURFACES_01~, \                     -- 01
            ~MATL_SURFACES_02~, \                     -- 02
            ~MATL_SURFACES_03~, \                     -- 03
            ~MATL_SURFACES_04~, \                     -- 04
            ~MATL_SURFACES_05~, \                     -- 05
            ~MATL_SURFACES_06~, \                     -- 06
            ~MATL_SURFACES_07~, \                     -- 07
            ~MATL_SURFACES_08~, \                     -- 08
            ~MATL_SURFACES_09~, \                     -- 09
            ~MATL_SURFACES_10~, \                     -- 10
            ~MATL_SURFACES_11~, \                     -- 11
            ~MATL_SURFACES_12~, \                     -- 12
            ~MATL_SURFACES_13~, \                     -- 13
            ~MATL_SURFACES_14~, \                     -- 14
            ~MATL_SURFACES_15~, \                     -- 15
            ~MATL_SURFACES_16~, \                     -- 16
            ~MATL_SURFACES_17~, \                     -- 17
            ~MATL_SURFACES_18~, \                     -- 18
            ~MATL_SURFACES_19~, \                     -- 19
            ~MATL_SURFACES_20~, \                     -- 20
            ~MATL_SURFACES_21~, \                     -- 21
            ~MATL_SURFACES_22~, \                     -- 22
            ~MATL_SURFACES_23~, \                     -- 23
            ~MATL_SURFACES_24~, \                     -- 24
            ~MATL_SURFACES_25~, \                     -- 25
            ~MATL_SURFACES_26~, \                     -- 26
            ~MATL_SURFACES_27~, \                     -- 27
            ~MATL_SURFACES_28~, \                     -- 28
            ~MATL_SURFACES_29~, \                     -- 29
            ~MATL_SURFACES_30~, \                     -- 30
            ~MATL_SURFACES_31~, \                     -- 31
            ~MATL_SURFACES_32~, \                     -- 32
            ~MATL_SURFACES_33~, \                     -- 33
            ~MATL_SURFACES_34~, \                     -- 34
            ~MATL_SURFACES_35~, \                     -- 35
            ~MATL_SURFACES_36~, \                     -- 36
            ~MATL_SURFACES_37~, \                     -- 37
            ~MATL_SURFACES_38~, \                     -- 38
            ~MATL_SURFACES_39~, \                     -- 39
            ~MATL_SURFACES_40~, \                     -- 40
            ~MATL_SURFACES_41~, \                     -- 41
            ~MATL_SURFACES_42~, \                     -- 42
            ~MATL_SURFACES_43~, \                     -- 43
            ~MATL_SURFACES_44~, \                     -- 44
            ~MATL_SURFACES_45~, \                     -- 45
            ~MATL_SURFACES_46~, \                     -- 46
            ~MATL_SURFACES_47~, \                     -- 47
            ~MATL_SURFACES_48~, \                     -- 48
            ~MATL_SURFACES_49~, \                     -- 49
            ~MATL_SURFACES_50~ \                      -- 50
          )

          global DYNuiResourcesObjectMaterial = #( \
            ~MATL_OBJECTS_01~, \                      -- 01
            ~MATL_OBJECTS_02~, \                      -- 02
            ~MATL_OBJECTS_03~, \                      -- 03
            ~MATL_OBJECTS_04~, \                      -- 04
            ~MATL_OBJECTS_05~, \                      -- 05
            ~MATL_OBJECTS_06~, \                      -- 06
            ~MATL_OBJECTS_07~, \                      -- 07
            ~MATL_OBJECTS_08~, \                      -- 08
            ~MATL_OBJECTS_09~, \                      -- 09
            ~MATL_OBJECTS_10~ \                       -- 10
          )

          global DYNuiResourcesMaterialMaps = #( \
            ~MATL_MAPS_ASPHALT_NOISE~, \              -- 01
            ~MATL_MAPS_CONCRETE_NOISE~, \             -- 02
            ~MATL_MAPS_PAVING_NOISE~, \               -- 03
            ~MATL_MAPS_GRASS_NOISE~, \                -- 04
            ~MATL_MAPS_SAND_SMOKE~, \                 -- 05
            ~MATL_MAPS_WATER_NOISE~, \                -- 06
            ~MATL_MAPS_WATER_BUMP_SMOKE~, \           -- 07
            ~MATL_MAPS_REFRACTION_SMOKE~, \           -- 08
            ~MATL_MAPS_VEHICLE_RAYTRACING~, \         -- 09
            ~MATL_MAPS_PREFIX_DIFFUSE~, \             -- 10
            ~MATL_MAPS_PREFIX_BUMP~, \                -- 11
            ~MATL_MAPS_PREFIX_OPACITY~, \             -- 12
            ~MATL_MAPS_MARKING_BUMP~, \               -- 13
            ~MATL_MAPS_PREFIX_MARKING~, \             -- 14
            ~MATL_MAPS_MARKING_CONTINUOUS~, \         -- 15
            ~MATL_MAPS_SUFFIX_FRONT~, \               -- 16
            ~MATL_MAPS_SUFFIX_BACK~, \                -- 17
            ~MATL_MAPS_STEEL~, \                      -- 18
            ~MATL_MAPS_ROOF_TEXTURE~ \                -- 19
          )

          global DYNuiResourcesUnitsTime = #( \
            ~UNIT_TIME_FRAME~, \                      -- 01
            ~UNIT_TIME_SECOND~, \                     -- 02
            ~UNIT_TIME_MINUTE~, \                     -- 03
            ~UNIT_TIME_HOUR~, \                       -- 04
            ~UNIT_TIME_FRAMES~ \                      -- 05
          )

          global DYNuiResourcesUnitsDistance = #( \
            ~UNIT_DIST_UNITS~, \                      -- 01
            ~UNIT_DIST_METRES~, \                     -- 02
            ~UNIT_DIST_KM~, \                         -- 03
            ~UNIT_DIST_CM~, \                         -- 04
            ~UNIT_DIST_MM~, \                         -- 05
            ~UNIT_DIST_MILES~, \                      -- 06
            ~UNIT_DIST_FEET~, \                       -- 07
            ~UNIT_DIST_INCHES~, \                     -- 08
            ~UNIT_WEIGHT_TONNES~, \                   -- 09
            ~UNIT_SPEED_METRES_SECOND~, \             -- 10
            ~UNIT_ACCEL_METRES_SEC_SEC~, \            -- 11
            ~UNIT_IMAGE_PIXELS~, \                    -- 12
            ~UNIT_MEMORY_BYTES~, \                    -- 13
            ~UNIT_ANGLE_DEGREES~, \                   -- 14
            ~UNIT_AREA_SQUARE_INCHES~, \              -- 15
            ~UNIT_AREA_SQUARE_FEET~, \                -- 16
            ~UNIT_AREA_SQUARE_MILES~, \               -- 17
            ~UNIT_AREA_SQUARE_MM~, \                  -- 18
            ~UNIT_AREA_SQUARE_CM~, \                  -- 19
            ~UNIT_AREA_SQUARE_M~, \                   -- 20
            ~UNIT_AREA_SQUARE_KM~ \                   -- 21
          )

          global DYNuiResourcesNodeNames = #( \
            ~GLOB_NODE_STATION_TEXT~, \               -- 01
            ~GLOB_NODE_TARGET~, \                     -- 02
            ~GLOB_NODE_PREFIX_TRAFFIC~, \             -- 03
            ~GLOB_NODE_DXF_SURFACE~, \                -- 04
            ~GLOB_NODE_DXF_SHAPE~, \                  -- 05
            ~GLOB_NODE_DEFAULT_SHAPE~, \              -- 06
            ~GLOB_NODE_OUTPUT_MODEL~, \               -- 07
            ~GLOB_NODE_OUTPUT_ALIGN_STRING~, \        -- 08
            ~GLOB_NODE_OUTPUT_OFFSET_STRING~, \       -- 09
            ~GLOB_NODE_PREFIX_SWEPTOBJECT~, \         -- 10
            ~GLOB_NODE_TRAILER~, \                    -- 11
            ~GLOB_NODE_PREFIX_MX_STRING~, \           -- 12
            ~GLOB_NODE_PREFIX_12D_STRING~, \          -- 13
            ~GLOB_NODE_PREFIX_C3D_BASELINE~, \        -- 14
            ~GLOB_NODE_PREFIX_C3D_FEATURELINE~, \     -- 15
            ~GLOB_NODE_PREFIX_C3D_ALIGNMENT~, \       -- 16
            ~GLOB_NODE_PREFIX_MX_POINTS~, \           -- 17
            ~GLOB_NODE_PREFIX_12D_POINTS~, \          -- 18
            ~GLOB_NODE_PREFIX_C3D_POINTS~, \          -- 19
            ~GLOB_NODE_PREFIX_C3D_PIPE~, \            -- 20
            ~GLOB_NODE_PREFIX_C3D_STRUCTURE~, \       -- 21
            ~GLOB_NODE_PREFIX_MX_SURFACE~, \          -- 22
            ~GLOB_NODE_PREFIX_12D_SURFACE~, \         -- 23
            ~GLOB_NODE_PREFIX_C3D_SURFACE~, \         -- 24
            ~GLOB_NODE_PREFIX_SPLINE_TO_SURFACE~, \   -- 25
            ~GLOB_NODE_FOREST_TWO_PLANES~, \          -- 26
            ~GLOB_NODE_PREFIX_BUILDING~, \            -- 27
            ~GLOB_NODE_PREFIX_RAIL~, \                -- 28
            ~GLOB_NODE_PREFIX_CHEVRON~, \             -- 29
            ~GLOB_NODE_PREFIX_MARK~, \                -- 30
            ~GLOB_NODE_PREFIX_XML_SURFACE~, \         -- 31
            ~GLOB_NODE_PREFIX_XML_SHAPE~, \           -- 32
            ~GLOB_NODE_PREFIX_XML_POINTS~, \          -- 33
            ~GLOB_NODE_PREFIX_PIPE_NETWORK~, \        -- 34
            ~GLOB_NODE_AXLE~ \                        -- 35
          )

          global DYNuiResourcesFolderNames = #( \
            ~GLOB_FOLDER_PROJECT_RESOURCES~ \         -- 01
          )

          global DYNuiResourcesFontNames = #( \
            ~GLOB_FONT_ARIAL~, \                      -- 01
            ~GLOB_FONT_COMIC_SANS_MS~, \              -- 02
            ~GLOB_FONT_COURIER_NEW~, \                -- 03
            ~GLOB_FONT_GEORGIA~, \                    -- 04
            ~GLOB_FONT_IMPACT~, \                     -- 05
            ~GLOB_FONT_LUCIDA_CONSOLE~, \             -- 06
            ~GLOB_FONT_PALATINO_LINOTYPE~, \          -- 07
            ~GLOB_FONT_TAHOMA~, \                     -- 08
            ~GLOB_FONT_TIMES_NEW_ROMAN~, \            -- 09
            ~GLOB_FONT_TREBUCHET_MS~, \               -- 10
            ~GLOB_FONT_VERDANA~, \                    -- 11
            ~GLOB_FONT_WEBDINGS~, \                   -- 12
            ~GLOB_FONT_WINGDINGS~ \                   -- 13
          )

          global DYNuiRolloutNames = #( \
            ~ROLLOUT_WORLDSTATISTICS~, \              -- 01
            ~ROLLOUT_VEHICLEPARAMS~, \                -- 02
            ~ROLLOUT_SCENESETTINGS~, \                -- 03
            ~ROLLOUT_ATMOSPHERE~, \                   -- 04
            ~ROLLOUT_TREEPARAMS~, \                   -- 05
            ~ROLLOUT_CAMPARAMS~, \                    -- 06
            ~ROLLOUT_ATTACHPARAMS~, \                 -- 07
            ~ROLLOUT_MATEDITOR~, \                    -- 08
            ~ROLLOUT_LIGHTLIST~, \                    -- 09
            ~ROLLOUT_PSYSTEMPARAMS~, \                -- 10
            ~ROLLOUT_SUNLIGHTPARAMS~, \               -- 11
            ~ROLLOUT_BUILDINGPARAMS~, \               -- 12
            ~ROLLOUT_BOS_EDITOR~, \                   -- 13
            ~ROLLOUT_SURFACEPARAMS~, \                -- 14
            ~ROLLOUT_MARKINGPARAMS~, \                -- 15
            ~ROLLOUT_PRIMITIVEPARAMS~, \              -- 16
            ~ROLLOUT_SHAPEPARAMS~, \                  -- 17
            ~ROLLOUT_ALIGNMENTPARAMS~, \              -- 18
            ~ROLLOUT_SIGNPARAMS~, \                   -- 19
            ~ROLLOUT_SIGNALPARAMS~, \                 -- 20
            ~ROLLOUT_PROPERTIES~, \                   -- 21
            ~ROLLOUT_SKYDOME~, \                      -- 22
            ~ROLLOUT_STD_LIGHT~, \                    -- 23
            ~ROLLOUT_LAMPPARAMS~, \                   -- 24
            ~ROLLOUT_GANTRYPARAMS~, \                 -- 25
            ~ROLLOUT_FORESTPARAMS~, \                 -- 26
            ~ROLLOUT_MR_FINALGATHER~, \               -- 27
            ~ROLLOUT_PHYSICAL_SUN_SKY~, \             -- 28
            ~ROLLOUT_MR_SKYLIGHT~, \                  -- 29
            ~ROLLOUT_MR_SUNLIGHT~, \                  -- 30
            ~ROLLOUT_POSITION_CONTROLLER~, \          -- 31
            ~ROLLOUT_ANIMATION_EDITOR~, \             -- 32
            ~ROLLOUT_EXPOSURE~, \                     -- 33
            ~ROLLOUT_SPLINEMAPPER~, \                 -- 34
            ~ROLLOUT_DRAPESPLINE~, \                  -- 35
            ~ROLLOUT_STATIONTEXT~, \                  -- 36
            ~ROLLOUT_PATHOBJECTLIST~, \               -- 37
            ~ROLLOUT_POINT_PLACEMENT~, \              -- 38
            ~ROLLOUT_DSIM_SURFACE~, \                 -- 39
            ~ROLLOUT_DSIM_SUBSTITUTE~, \              -- 40
            ~ROLLOUT_FZP_IMPORT~, \                   -- 41
            ~ROLLOUT_PLACEDMAN~, \                    -- 42
            ~ROLLOUT_CVE_GENIO~, \                    -- 43
            ~ROLLOUT_CVE_MODELFILE~, \                -- 44
            ~ROLLOUT_CVE_TWELVED~, \                  -- 45
            ~ROLLOUT_C3DIMPORT~, \                    -- 46
            ~ROLLOUT_DXFIMPORT~, \                    -- 47
            ~ROLLOUT_EXPLORER~, \                     -- 48
            ~ROLLOUT_SIGHT_CHECKER~, \                -- 49
            ~ROLLOUT_GRAILOBJECTS~, \                 -- 50
            ~ROLLOUT_GRAILPARAMS~, \                  -- 51
            ~ROLLOUT_ROADMARKINGS~, \                 -- 52
            ~ROLLOUT_FIS_EDITOR~, \                   -- 53
            ~ROLLOUT_OBJECTPLACER~, \                 -- 54
            ~ROLLOUT_BUILDSHAPE~, \                   -- 55
            ~ROLLOUT_SWEPTOBJECTS~, \                 -- 56
            ~ROLLOUT_SOSPARAMS~, \                    -- 57
            ~ROLLOUT_IMPORTMAN~, \                    -- 58
            ~ROLLOUT_QPARIMPORT~, \                   -- 59
            ~ROLLOUT_RESOURCEMAN~, \                  -- 60
            ~ROLLOUT_RESOURCELIST_STYLES~, \          -- 61
            ~ROLLOUT_RESOURCELIST_OBJECTS~, \         -- 62
            ~ROLLOUT_CVE_LANDXML~, \                  -- 63
            ~ROLLOUT_MX_INPUT_FILE_OUTPUT~, \         -- 64
            ~ROLLOUT_CLONE_ATTACHED_OBJECT~, \        -- 65
            ~ROLLOUT_CLONE_PATH_OBJECT~, \            -- 66
            ~ROLLOUT_PIPENETWORK_PARAMS~, \           -- 67
            ~ROLLOUT_SUNLIGHT_POSITIONER~, \          -- 68
            ~ROLLOUT_GIF_CHECKER~ \                   -- 69
          )

          global DYNuiResourcesMainMenu = #( \
            ~MAINMENU_GEOMETRY_IMPORT~, \             -- 01
            ~MAINMENU_TRAFFIC_IMPORT~, \              -- 02
            ~MAINMENU_TOOLS~, \                       -- 03
            ~MAINMENU_EXPLORER~, \                    -- 04
            ~MAINMENU_OBJECTPLACER~, \                -- 05
            ~MAINMENU_SWEPTOBJECTS~, \                -- 06
            ~MAINMENU_ROADMARKINGS~, \                -- 07
            ~MAINMENU_GRAILOBJECTS~, \                -- 08
            ~MAINMENU_BUILDINGOBJECTS~, \             -- 09
            ~MAINMENU_FEATUREINTERP~, \               -- 10
            ~MAINMENU_PROPERTIES~, \                  -- 11
            ~MAINMENU_IMPORTMAN~, \                   -- 12
            ~MAINMENU_PLACEDMAN~, \                   -- 13
            ~MAINMENU_PREFERENCES~, \                 -- 14
            ~MAINMENU_RESOURCE_KIT~, \                -- 15
            ~MAINMENU_IMPORT_CIVIL3D~, \              -- 16
            ~MAINMENU_IMPORT_MODELFILE~, \            -- 17
            ~MAINMENU_IMPORT_GENIO~, \                -- 18
            ~MAINMENU_IMPORT_12D~, \                  -- 19
            ~MAINMENU_IMPORT_LANDXML~, \              -- 20
            ~MAINMENU_IMPORT_DXF~, \                  -- 21
            ~MAINMENU_IMPORT_SIM~, \                  -- 22
            ~MAINMENU_IMPORT_FZP~, \                  -- 23
            ~MAINMENU_SURFACE_MANAGER~, \             -- 24
            ~MAINMENU_SUBSTITUTION_MANAGER~, \        -- 25
            ~MAINMENU_MEASURE_BEARING~ \              -- 26
          )

          --- End Localizable Resource Strings -----------------------------------------

          --- Create and display Civil View Startup Splash Panel
          local LOCexe = "rollout DYNsplashPanel \"\"\n"
          LOCexe += "(\n"
          LOCexe += "  dotNetControl dnImageBox \"ThreeAm.DVSP.Controls.ImageBox\"   pos:[3,3]   width:860 height:500\n"
          LOCexe += "  label LBDYNlabel01 pos:[4,507] width:860 height:15\n"
          LOCexe += "\n"
          LOCexe += "  on DYNsplashPanel open do\n"
          LOCexe += "  (\n"
          LOCexe += "    DYNsplashPanel.title    = DYNuiResourcesTitlebars[59]\n"
          LOCexe += "    dnImageBox.BorderStyle  = DYNdnBorderStyleClass.FixedSingle\n"
          LOCexe += "    dnImageBox.resourceName = \"Splash.bmp\"\n" -- case sensitive
          LOCexe += "    dnImageBox.refresh()\n"
          LOCexe += "  )\n"
          LOCexe += ")\n"
          /* Create and display rollout */
          DYNsplashPanel = execute LOCexe
          createDialog DYNsplashPanel width:866 height:525 modal:false style:#(#style_border)
          DYNsplashPanel.LBDYNlabel01.text = DYNuiResourcesStatusMessages[1]

          --- Set Up Defaults
          DYNFUNsetupRootNode()

          --- Get System Data Locale
          /*
            Valid Values
            1 = DD/MM/YY (Default)
            2 = MM/DD/YY
            3 = YY/MM/DD
          */
          DYNdateLocale = 1 -- Default value (DD/MM/YY)

          local LOCsysInfo = sysinfo.getLanguage user:true

          --- Set MM/DD/YY Locales
          if LOCsysInfo[1] ==   9 and LOCsysInfo[2] ==  9 then DYNdateLocale = 2 -- Caribbean
          if LOCsysInfo[1] == 124 and LOCsysInfo[2] ==  1 then DYNdateLocale = 2 -- Mowhawk
          if LOCsysInfo[1] ==  10 and LOCsysInfo[2] ==  6 then DYNdateLocale = 2 -- Panama
          if LOCsysInfo[1] ==   9 and LOCsysInfo[2] == 13 then DYNdateLocale = 2 -- Phillipinnes
          if LOCsysInfo[1] ==  65 and LOCsysInfo[2] ==  1 then DYNdateLocale = 2 -- Swahili
          if LOCsysInfo[1] ==   9 and LOCsysInfo[2] ==  1 then DYNdateLocale = 2 -- United States
          if LOCsysInfo[1] ==   9 and LOCsysInfo[2] == 12 then DYNdateLocale = 2 -- Zimbabwe

          --- Set YY/MM/DD Locales
          if LOCsysInfo[1] ==  54 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Afrikaans
          if LOCsysInfo[1] ==  28 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Albanian
          if LOCsysInfo[1] ==  45 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Basque
          if LOCsysInfo[1] ==   9 and LOCsysInfo[2] ==  7 then DYNdateLocale = 3 -- South Africa
          if LOCsysInfo[1] ==  12 and LOCsysInfo[2] ==  3 then DYNdateLocale = 3 -- French Canada
          if LOCsysInfo[1] ==  14 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Hungary
          if LOCsysInfo[1] ==  38 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Latvia
          if LOCsysInfo[1] ==  39 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Lithuania
          if LOCsysInfo[1] ==  80 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Mongolia
          if LOCsysInfo[1] == 108 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Northern Sotho
          if LOCsysInfo[1] ==  21 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Poland
          if LOCsysInfo[1] ==  59 and LOCsysInfo[2] ==  5 then DYNdateLocale = 3 -- Sweden (Sami Lule)
          if LOCsysInfo[1] ==  59 and LOCsysInfo[2] ==  2 then DYNdateLocale = 3 -- Sweden (Sami Northern)
          if LOCsysInfo[1] ==  59 and LOCsysInfo[2] ==  7 then DYNdateLocale = 3 -- Sweden (Sami Southern)
          if LOCsysInfo[1] ==  29 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Sweden
          if LOCsysInfo[1] ==  50 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Tswana
          if LOCsysInfo[1] ==  52 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Xhosa
          if LOCsysInfo[1] ==  53 and LOCsysInfo[2] ==  1 then DYNdateLocale = 3 -- Zulu

          --- Find Installed Country Resource Kits
        DYNFUNsetCountryPaths DYNINIcountry DYNcountryRootPath
          --- Load MacroScripts
          macros.load ((getdir #maxroot) + "stdplugs\\(CivilView)\\")

          --- Load Civil View UI and Materials
          /*
          Rollouts must be loaded with fileIn from a separate script. In fileIn, the script file content is compiled in a global scope context,
          as opposed to the scope in effect when the filein() method is executed. Simply pasting the content of CivilViewRollouts into this startup
          script would cause this content to be loaded into a local context which would not work.
          */
          fileIn (DYNscriptsPath + "CivilViewRollouts.ms")
          fileIn (DYNscriptsPath + "CivilViewSurfaces.ms")
          fileIn (DYNscriptsPath + "CivilViewVehicles.ms")

          --- Initialize Civil View Global Variables and Paths
        DYNFUNdynamiteInitialise DYNuiResourcesStatusMessages[1] DYNINIcountry DYNINIexplorerWidth DYNsplashPanel.LBDYNlabel01 DYNINIhighlightColor DYNINIgreyedOutColor DYNINIstartMarkerColor DYNINIendMarkerColor DYNINIframeRate DYNINImarkerSize DYNINIcomPanel DYNINIspeedValue DYNINItreeVariation DYNINIresetMaxMenu DYNINIdisableGrid DYNINIungpMatChan DYNINImarkingColor DYNINIdockExplorer DYNINIshowIcons DYNINIenableFog DYNINIchainageLoop DYNINIretainOPSmat DYNINIallowMultMarks DYNINIallowMultRails DYNINIshadowSaver DYNINIprivateKit DYNINIprojectKit DYNINIprivateKitPath DYNINIprojectKitPath DYNINIoverhangCorrect DYNINIhideDiagonals DYNINIfaceSmoothing DYNINImatIDlimit DYNINIautoStart DYNINIrotateWheels DYNcountryRootPath

          --- Load MAIN PullDown Menu (must be placed AFTER loading of MacroScripts and after Initialisde Script)
        local LOCmainMenuBar  = DYNFUNremoveCivilViewFromMainMenu()
        DynDVSPmenuMain       = menuMan.createMenu (DYNcivilViewProductName)
          DynDVSPmenuCV         = menuMan.createMenu (DYNcivilViewProductName)
          DynDVSPmenuImport     = menuMan.createMenu DYNuiResourcesMainMenu[1]
          DynDSIMmenuMain       = menuMan.createMenu DYNuiResourcesMainMenu[2]

          --- Create Menu Items
          local DYNmenuItem0 = menuMan.createSeparatorItem()
          local DYNmenuItem1 = menuMan.createActionItem  "MCRexplorer"        "Civil View"
          local DYNmenuItem2 = menuMan.createActionItem  "MCRpreferences"     "Civil View"
          local DYNmenuIteme = menuMan.createActionItem  "MCRproperties"      "Civil View"
          local DYNmenuItemf = menuMan.createActionItem  "MCRsweptObjects"    "Civil View"
          local DYNmenuItemg = menuMan.createActionItem  "MCRobjectPlacer"    "Civil View"
          local DYNmenuItemh = menuMan.createActionItem  "MCRroadMarkings"    "Civil View"
          local DYNmenuItemi = menuMan.createActionItem  "MCRdxfImport"       "Civil View"
          local DYNmenuItemj = menuMan.createActionItem  "MCRgenioImport"     "Civil View"
          local DYNmenuItemk = menuMan.createActionItem  "MCRresourceMan"     "Civil View"
          local DYNmenuIteml = menuMan.createActionItem  "MCRimportMan"       "Civil View"
          local DYNmenuItemm = menuMan.createActionItem  "MCRplacedMan"       "Civil View"
          local DYNmenuItemr = menuMan.createActionItem  "MCRmxImport"        "Civil View"
          local DYNmenuItems = menuMan.createActionItem  "MCRfeatureInterp"   "Civil View"
          local DYNmenuItemt = menuMan.createActionItem  "MCR12dImport"       "Civil View"
          local DYNmenuItemu = menuMan.createActionItem  "MCRlandXMLimport"   "Civil View"
          local DYNmenuItemv = menuMan.createActionItem  "MCRgRailObjects"    "Civil View"
          local DYNmenuItemw = menuMan.createActionItem  "MCRbuildingObjects" "Civil View"
          local DYNmenuItemy = menuMan.createActionItem  "MCRc3dImport"       "Civil View"

          local DYNdSimItem1 = menuMan.createActionItem  "MCRdsimImport"      "Civil View"
          local DYNdSimItem6 = menuMan.createActionItem  "MCRqparImport"      "Civil View"
          local DYNdSimItem2 = menuMan.createActionItem  "MCRdsimSurface"     "Civil View"
          local DYNdSimItem3 = menuMan.createActionItem  "MCRdsimSubstitute"  "Civil View"
          local DYNdSimItem5 = menuMan.createActionItem  "MCRdsimBearing"     "Civil View"

          local DYNdSimItem4 = menuMan.createSubMenuItem (DYNcivilViewProductName) DynDVSPmenuCV
          local DYNmenuItem5 = menuMan.createSubMenuItem DYNuiResourcesMainMenu[1] DynDVSPmenuImport
          local DYNdSimItem0 = menuMan.createSubMenuItem DYNuiResourcesMainMenu[2] DynDSIMmenuMain

          --- Create CV Menu
          DYNmenuItem1.setUseCustomTitle true  ; DYNmenuItem1.setTitle DYNuiResourcesMainMenu[4]   ; DynDVSPmenuCV.addItem DYNmenuItem1 -1
          DynDVSPmenuCV.addItem DYNmenuItem0 -1
          DYNmenuItemg.setUseCustomTitle true  ; DYNmenuItemg.setTitle DYNuiResourcesMainMenu[5]   ; DynDVSPmenuCV.addItem DYNmenuItemg -1
          DYNmenuItemf.setUseCustomTitle true  ; DYNmenuItemf.setTitle DYNuiResourcesMainMenu[6]   ; DynDVSPmenuCV.addItem DYNmenuItemf -1
          DYNmenuItemh.setUseCustomTitle true  ; DYNmenuItemh.setTitle DYNuiResourcesMainMenu[7]   ; DynDVSPmenuCV.addItem DYNmenuItemh -1
          DYNmenuItemv.setUseCustomTitle true  ; DYNmenuItemv.setTitle DYNuiResourcesMainMenu[8]   ; DynDVSPmenuCV.addItem DYNmenuItemv -1
          DYNmenuItemw.setUseCustomTitle true  ; DYNmenuItemw.setTitle DYNuiResourcesMainMenu[9]   ; DynDVSPmenuCV.addItem DYNmenuItemw -1
		  DYNmenuItem0 = menuMan.createSeparatorItem()
          DynDVSPmenuCV.addItem DYNmenuItem0 -1
          DYNmenuItems.setUseCustomTitle true  ; DYNmenuItems.setTitle DYNuiResourcesMainMenu[10]  ; DynDVSPmenuCV.addItem DYNmenuItems -1
		  DYNmenuItem0 = menuMan.createSeparatorItem()
          DynDVSPmenuCV.addItem DYNmenuItem0 -1
          DYNmenuIteme.setUseCustomTitle true  ; DYNmenuIteme.setTitle DYNuiResourcesMainMenu[11]  ; DynDVSPmenuCV.addItem DYNmenuIteme -1
          DYNmenuIteml.setUseCustomTitle true  ; DYNmenuIteml.setTitle DYNuiResourcesMainMenu[12]  ; DynDVSPmenuCV.addItem DYNmenuIteml -1
          DYNmenuItemm.setUseCustomTitle true  ; DYNmenuItemm.setTitle DYNuiResourcesMainMenu[13]  ; DynDVSPmenuCV.addItem DYNmenuItemm -1
		  DYNmenuItem0 = menuMan.createSeparatorItem()
          DynDVSPmenuCV.addItem DYNmenuItem0 -1
          DYNmenuItemk.setUseCustomTitle true  ; DYNmenuItemk.setTitle DYNuiResourcesMainMenu[15]  ; DynDVSPmenuCV.addItem DYNmenuItemk -1
		  DYNmenuItem0 = menuMan.createSeparatorItem()
          DynDVSPmenuCV.addItem DYNmenuItem0 -1
          DYNmenuItem2.setUseCustomTitle true  ; DYNmenuItem2.setTitle DYNuiResourcesMainMenu[14]  ; DynDVSPmenuCV.addItem DYNmenuItem2 -1

          DynDVSPmenuMain.addItem DYNdSimItem4 -1
          DynDVSPmenuMain.addItem DYNmenuItem5 -1
          DynDVSPmenuMain.addItem DYNdSimItem0 -1

          --- Create Dynamite IMPORT Submenu
          DYNmenuItemy.setUseCustomTitle true  ; DYNmenuItemy.setTitle DYNuiResourcesMainMenu[16]  ; DynDVSPmenuImport.addItem DYNmenuItemy -1
		  DYNmenuItem0 = menuMan.createSeparatorItem()
          DynDVSPmenuImport.addItem DYNmenuItem0 -1
          DYNmenuItemr.setUseCustomTitle true  ; DYNmenuItemr.setTitle DYNuiResourcesMainMenu[17]  ; DynDVSPmenuImport.addItem DYNmenuItemr -1
          DYNmenuItemj.setUseCustomTitle true  ; DYNmenuItemj.setTitle DYNuiResourcesMainMenu[18]  ; DynDVSPmenuImport.addItem DYNmenuItemj -1
		  DYNmenuItem0 = menuMan.createSeparatorItem()
          DynDVSPmenuImport.addItem DYNmenuItem0 -1
          DYNmenuItemt.setUseCustomTitle true  ; DYNmenuItemt.setTitle DYNuiResourcesMainMenu[19]  ; DynDVSPmenuImport.addItem DYNmenuItemt -1
		  DYNmenuItem0 = menuMan.createSeparatorItem()
          DynDVSPmenuImport.addItem DYNmenuItem0 -1
          DYNmenuItemu.setUseCustomTitle true  ; DYNmenuItemu.setTitle DYNuiResourcesMainMenu[20]  ; DynDVSPmenuImport.addItem DYNmenuItemu -1
          DYNmenuItemi.setUseCustomTitle true  ; DYNmenuItemi.setTitle DYNuiResourcesMainMenu[21]  ; DynDVSPmenuImport.addItem DYNmenuItemi -1

          --- Create Dynamite TRAFFIC Submenu
          DYNdSimItem6.setUseCustomTitle true  ; DYNdSimItem6.setTitle DYNuiResourcesMainMenu[22]  ; DynDSIMmenuMain.addItem DYNdSimItem6 -1
          DYNdSimItem1.setUseCustomTitle true  ; DYNdSimItem1.setTitle DYNuiResourcesMainMenu[23]  ; DynDSIMmenuMain.addItem DYNdSimItem1 -1
		  DYNmenuItem0 = menuMan.createSeparatorItem()
          DynDSIMmenuMain.addItem DYNmenuItem0 -1
          DYNdSimItem2.setUseCustomTitle true  ; DYNdSimItem2.setTitle DYNuiResourcesMainMenu[24]  ; DynDSIMmenuMain.addItem DYNdSimItem2 -1
          DYNdSimItem3.setUseCustomTitle true  ; DYNdSimItem3.setTitle DYNuiResourcesMainMenu[25]  ; DynDSIMmenuMain.addItem DYNdSimItem3 -1
		  DYNmenuItem0 = menuMan.createSeparatorItem()
          DynDSIMmenuMain.addItem DYNmenuItem0 -1
          DYNdSimItem5.setUseCustomTitle true  ; DYNdSimItem5.setTitle DYNuiResourcesMainMenu[26]  ; DynDSIMmenuMain.addItem DYNdSimItem5 -1

          --- Create a new menu item with the menu as it's sub-menu
          local DynDVSPmenuMainPosition = LOCmainMenuBar.numItems() - 3
        local DynDVSPmenuMainItem     = menuMan.createSubMenuItem (DYNcivilViewProductName) DynDVSPmenuMain
          DynDVSPmenuMainItem.setUseCustomTitle true
        DynDVSPmenuMainItem.setTitle (DYNcivilViewProductName)
          LOCmainMenuBar.addItem DynDVSPmenuMainItem DynDVSPmenuMainPosition
          menuMan.updateMenuBar()

          --- Close Civil View Startup Splash Panel
          try (destroyDialog DYNsplashPanel) catch ()
        )
      )
  )
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBGjncKwaU8pPkUQGP0XTVrxiCyxlYsvwm8
-- g+TVeU3Mu5FjDniKWAgnxafgz2c+89WKMoyjSGdUV6Sl/Dxp3jDVq8fgswDPeA87
-- 8A2kYPDV4nTOY5K1fG4F9G0DNgMmAmb0GGfEINbUw4YaG5/ZlT7gmv+ZPn/wcb3g
-- KC9a7EMKuSapHWxOfXmhDdjwpN2x5U0AZ/SP3Pj9HG6quvApX8Z5Gat4hLH3s+J1
-- OM1LbkPsLK7OiOTGovhGRYKft0gK4Gd53shUCTtlykXi/bcURN18J9MdWjc1dYI+
-- IB8Pe9cuXMqtbW3XcBeFaOS9YaKyAihcI31cKyBVsOE0N0W+cYxd
-- -----END-SIGNATURE-----